package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class StatelessCustomPublishMetricActionDimension(
    value: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.StatelessCustomPublishMetricActionDimension = {
    import StatelessCustomPublishMetricActionDimension.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.StatelessCustomPublishMetricActionDimension
      .builder()
      .optionallyWith(
        value.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.value)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.StatelessCustomPublishMetricActionDimension.ReadOnly =
    zio.aws.securityhub.model.StatelessCustomPublishMetricActionDimension
      .wrap(buildAwsValue())
}
object StatelessCustomPublishMetricActionDimension {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.StatelessCustomPublishMetricActionDimension
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.StatelessCustomPublishMetricActionDimension =
      zio.aws.securityhub.model
        .StatelessCustomPublishMetricActionDimension(value.map(value => value))
    def value: Option[NonEmptyString]
    def getValue: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.StatelessCustomPublishMetricActionDimension
  ) extends zio.aws.securityhub.model.StatelessCustomPublishMetricActionDimension.ReadOnly {
    override val value: Option[NonEmptyString] = scala
      .Option(impl.value())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.StatelessCustomPublishMetricActionDimension
  ): zio.aws.securityhub.model.StatelessCustomPublishMetricActionDimension.ReadOnly =
    new Wrapper(impl)
}
