package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class SensitiveDataDetections(
    count: Option[Long] = None,
    `type`: Option[NonEmptyString] = None,
    occurrences: Option[zio.aws.securityhub.model.Occurrences] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.SensitiveDataDetections = {
    import SensitiveDataDetections.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.SensitiveDataDetections
      .builder()
      .optionallyWith(count.map(value => value: java.lang.Long))(_.count)
      .optionallyWith(
        `type`.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.`type`)
      .optionallyWith(occurrences.map(value => value.buildAwsValue()))(
        _.occurrences
      )
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.SensitiveDataDetections.ReadOnly =
    zio.aws.securityhub.model.SensitiveDataDetections.wrap(buildAwsValue())
}
object SensitiveDataDetections {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.SensitiveDataDetections
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.SensitiveDataDetections =
      zio.aws.securityhub.model.SensitiveDataDetections(
        count.map(value => value),
        `type`.map(value => value),
        occurrences.map(value => value.asEditable)
      )
    def count: Option[Long]
    def `type`: Option[NonEmptyString]
    def occurrences: Option[zio.aws.securityhub.model.Occurrences.ReadOnly]
    def getCount: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("count", count)
    def getType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("type", `type`)
    def getOccurrences
        : ZIO[Any, AwsError, zio.aws.securityhub.model.Occurrences.ReadOnly] =
      AwsError.unwrapOptionField("occurrences", occurrences)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.SensitiveDataDetections
  ) extends zio.aws.securityhub.model.SensitiveDataDetections.ReadOnly {
    override val count: Option[Long] =
      scala.Option(impl.count()).map(value => value: Long)
    override val `type`: Option[NonEmptyString] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val occurrences
        : Option[zio.aws.securityhub.model.Occurrences.ReadOnly] = scala
      .Option(impl.occurrences())
      .map(value => zio.aws.securityhub.model.Occurrences.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.SensitiveDataDetections
  ): zio.aws.securityhub.model.SensitiveDataDetections.ReadOnly = new Wrapper(
    impl
  )
}
