package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class RuleGroupSourceListDetails(
    generatedRulesType: Option[NonEmptyString] = None,
    targetTypes: Option[Iterable[NonEmptyString]] = None,
    targets: Option[Iterable[NonEmptyString]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.RuleGroupSourceListDetails = {
    import RuleGroupSourceListDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.RuleGroupSourceListDetails
      .builder()
      .optionallyWith(
        generatedRulesType.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.generatedRulesType)
      .optionallyWith(
        targetTypes.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.targetTypes)
      .optionallyWith(
        targets.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.targets)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.RuleGroupSourceListDetails.ReadOnly =
    zio.aws.securityhub.model.RuleGroupSourceListDetails.wrap(buildAwsValue())
}
object RuleGroupSourceListDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.RuleGroupSourceListDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.RuleGroupSourceListDetails =
      zio.aws.securityhub.model.RuleGroupSourceListDetails(
        generatedRulesType.map(value => value),
        targetTypes.map(value => value),
        targets.map(value => value)
      )
    def generatedRulesType: Option[NonEmptyString]
    def targetTypes: Option[List[NonEmptyString]]
    def targets: Option[List[NonEmptyString]]
    def getGeneratedRulesType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("generatedRulesType", generatedRulesType)
    def getTargetTypes: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("targetTypes", targetTypes)
    def getTargets: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("targets", targets)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.RuleGroupSourceListDetails
  ) extends zio.aws.securityhub.model.RuleGroupSourceListDetails.ReadOnly {
    override val generatedRulesType: Option[NonEmptyString] = scala
      .Option(impl.generatedRulesType())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val targetTypes: Option[List[NonEmptyString]] = scala
      .Option(impl.targetTypes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.primitives.NonEmptyString(item)
        }.toList
      )
    override val targets: Option[List[NonEmptyString]] = scala
      .Option(impl.targets())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.primitives.NonEmptyString(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.RuleGroupSourceListDetails
  ): zio.aws.securityhub.model.RuleGroupSourceListDetails.ReadOnly =
    new Wrapper(impl)
}
