package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PortProbeAction(
    portProbeDetails: Option[
      Iterable[zio.aws.securityhub.model.PortProbeDetail]
    ] = None,
    blocked: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.PortProbeAction = {
    import PortProbeAction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.PortProbeAction
      .builder()
      .optionallyWith(
        portProbeDetails.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.portProbeDetails)
      .optionallyWith(blocked.map(value => value: java.lang.Boolean))(_.blocked)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.PortProbeAction.ReadOnly =
    zio.aws.securityhub.model.PortProbeAction.wrap(buildAwsValue())
}
object PortProbeAction {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.PortProbeAction
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.PortProbeAction =
      zio.aws.securityhub.model.PortProbeAction(
        portProbeDetails.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        blocked.map(value => value)
      )
    def portProbeDetails
        : Option[List[zio.aws.securityhub.model.PortProbeDetail.ReadOnly]]
    def blocked: Option[Boolean]
    def getPortProbeDetails: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.PortProbeDetail.ReadOnly
    ]] = AwsError.unwrapOptionField("portProbeDetails", portProbeDetails)
    def getBlocked: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("blocked", blocked)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.PortProbeAction
  ) extends zio.aws.securityhub.model.PortProbeAction.ReadOnly {
    override val portProbeDetails
        : Option[List[zio.aws.securityhub.model.PortProbeDetail.ReadOnly]] =
      scala
        .Option(impl.portProbeDetails())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.PortProbeDetail.wrap(item)
          }.toList
        )
    override val blocked: Option[Boolean] =
      scala.Option(impl.blocked()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.PortProbeAction
  ): zio.aws.securityhub.model.PortProbeAction.ReadOnly = new Wrapper(impl)
}
