package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class NumberFilter(
    gte: Option[Double] = None,
    lte: Option[Double] = None,
    eq: Option[Double] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.NumberFilter = {
    import NumberFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.NumberFilter
      .builder()
      .optionallyWith(gte.map(value => value: java.lang.Double))(_.gte)
      .optionallyWith(lte.map(value => value: java.lang.Double))(_.lte)
      .optionallyWith(eq.map(value => value: java.lang.Double))(_.eq)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.NumberFilter.ReadOnly =
    zio.aws.securityhub.model.NumberFilter.wrap(buildAwsValue())
}
object NumberFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.NumberFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.NumberFilter =
      zio.aws.securityhub.model.NumberFilter(
        gte.map(value => value),
        lte.map(value => value),
        eq.map(value => value)
      )
    def gte: Option[Double]
    def lte: Option[Double]
    def eq: Option[Double]
    def getGte: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("gte", gte)
    def getLte: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("lte", lte)
    def getEq: ZIO[Any, AwsError, Double] = AwsError.unwrapOptionField("eq", eq)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.NumberFilter
  ) extends zio.aws.securityhub.model.NumberFilter.ReadOnly {
    override val gte: Option[Double] =
      scala.Option(impl.gte()).map(value => value: Double)
    override val lte: Option[Double] =
      scala.Option(impl.lte()).map(value => value: Double)
    override val eq: Option[Double] =
      scala.Option(impl.eq()).map(value => value: Double)
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.NumberFilter
  ): zio.aws.securityhub.model.NumberFilter.ReadOnly = new Wrapper(impl)
}
