package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class KeywordFilter(value: Option[NonEmptyString] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.KeywordFilter = {
    import KeywordFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.KeywordFilter
      .builder()
      .optionallyWith(
        value.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.value)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.KeywordFilter.ReadOnly =
    zio.aws.securityhub.model.KeywordFilter.wrap(buildAwsValue())
}
object KeywordFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.KeywordFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.KeywordFilter =
      zio.aws.securityhub.model.KeywordFilter(value.map(value => value))
    def value: Option[NonEmptyString]
    def getValue: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.KeywordFilter
  ) extends zio.aws.securityhub.model.KeywordFilter.ReadOnly {
    override val value: Option[NonEmptyString] = scala
      .Option(impl.value())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.KeywordFilter
  ): zio.aws.securityhub.model.KeywordFilter.ReadOnly = new Wrapper(impl)
}
