package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class InviteMembersRequest(accountIds: Iterable[NonEmptyString]) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.InviteMembersRequest = {
    import InviteMembersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.InviteMembersRequest
      .builder()
      .accountIds(accountIds.map { item =>
        NonEmptyString.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.InviteMembersRequest.ReadOnly =
    zio.aws.securityhub.model.InviteMembersRequest.wrap(buildAwsValue())
}
object InviteMembersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.InviteMembersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.InviteMembersRequest =
      zio.aws.securityhub.model.InviteMembersRequest(accountIds)
    def accountIds: List[NonEmptyString]
    def getAccountIds: ZIO[Any, Nothing, List[NonEmptyString]] =
      ZIO.succeed(accountIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.InviteMembersRequest
  ) extends zio.aws.securityhub.model.InviteMembersRequest.ReadOnly {
    override val accountIds: List[NonEmptyString] = impl
      .accountIds()
      .asScala
      .map { item =>
        zio.aws.securityhub.model.primitives.NonEmptyString(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.InviteMembersRequest
  ): zio.aws.securityhub.model.InviteMembersRequest.ReadOnly = new Wrapper(impl)
}
