package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{
  Timestamp,
  NonEmptyString,
  AccountId
}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class Invitation(
    accountId: Option[AccountId] = None,
    invitationId: Option[NonEmptyString] = None,
    invitedAt: Option[Timestamp] = None,
    memberStatus: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.Invitation = {
    import Invitation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.Invitation
      .builder()
      .optionallyWith(
        accountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.accountId)
      .optionallyWith(
        invitationId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.invitationId)
      .optionallyWith(invitedAt.map(value => Timestamp.unwrap(value): Instant))(
        _.invitedAt
      )
      .optionallyWith(
        memberStatus.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.memberStatus)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.Invitation.ReadOnly =
    zio.aws.securityhub.model.Invitation.wrap(buildAwsValue())
}
object Invitation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.Invitation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.Invitation =
      zio.aws.securityhub.model.Invitation(
        accountId.map(value => value),
        invitationId.map(value => value),
        invitedAt.map(value => value),
        memberStatus.map(value => value)
      )
    def accountId: Option[AccountId]
    def invitationId: Option[NonEmptyString]
    def invitedAt: Option[Timestamp]
    def memberStatus: Option[NonEmptyString]
    def getAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getInvitationId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("invitationId", invitationId)
    def getInvitedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("invitedAt", invitedAt)
    def getMemberStatus: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("memberStatus", memberStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.Invitation
  ) extends zio.aws.securityhub.model.Invitation.ReadOnly {
    override val accountId: Option[AccountId] = scala
      .Option(impl.accountId())
      .map(value => zio.aws.securityhub.model.primitives.AccountId(value))
    override val invitationId: Option[NonEmptyString] = scala
      .Option(impl.invitationId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val invitedAt: Option[Timestamp] = scala
      .Option(impl.invitedAt())
      .map(value => zio.aws.securityhub.model.primitives.Timestamp(value))
    override val memberStatus: Option[NonEmptyString] = scala
      .Option(impl.memberStatus())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.Invitation
  ): zio.aws.securityhub.model.Invitation.ReadOnly = new Wrapper(impl)
}
