package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.Integer
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetInvitationsCountResponse(
    invitationsCount: Option[Integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.GetInvitationsCountResponse = {
    import GetInvitationsCountResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.GetInvitationsCountResponse
      .builder()
      .optionallyWith(
        invitationsCount.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.invitationsCount)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.GetInvitationsCountResponse.ReadOnly =
    zio.aws.securityhub.model.GetInvitationsCountResponse.wrap(buildAwsValue())
}
object GetInvitationsCountResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.GetInvitationsCountResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.GetInvitationsCountResponse =
      zio.aws.securityhub.model
        .GetInvitationsCountResponse(invitationsCount.map(value => value))
    def invitationsCount: Option[Integer]
    def getInvitationsCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("invitationsCount", invitationsCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.GetInvitationsCountResponse
  ) extends zio.aws.securityhub.model.GetInvitationsCountResponse.ReadOnly {
    override val invitationsCount: Option[Integer] = scala
      .Option(impl.invitationsCount())
      .map(value => zio.aws.securityhub.model.primitives.Integer(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.GetInvitationsCountResponse
  ): zio.aws.securityhub.model.GetInvitationsCountResponse.ReadOnly =
    new Wrapper(impl)
}
