package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DisableImportFindingsForProductRequest(
    productSubscriptionArn: NonEmptyString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.DisableImportFindingsForProductRequest = {
    import DisableImportFindingsForProductRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.DisableImportFindingsForProductRequest
      .builder()
      .productSubscriptionArn(
        NonEmptyString.unwrap(productSubscriptionArn): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.DisableImportFindingsForProductRequest.ReadOnly =
    zio.aws.securityhub.model.DisableImportFindingsForProductRequest
      .wrap(buildAwsValue())
}
object DisableImportFindingsForProductRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.DisableImportFindingsForProductRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.DisableImportFindingsForProductRequest =
      zio.aws.securityhub.model
        .DisableImportFindingsForProductRequest(productSubscriptionArn)
    def productSubscriptionArn: NonEmptyString
    def getProductSubscriptionArn: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(productSubscriptionArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.DisableImportFindingsForProductRequest
  ) extends zio.aws.securityhub.model.DisableImportFindingsForProductRequest.ReadOnly {
    override val productSubscriptionArn: NonEmptyString =
      zio.aws.securityhub.model.primitives
        .NonEmptyString(impl.productSubscriptionArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.DisableImportFindingsForProductRequest
  ): zio.aws.securityhub.model.DisableImportFindingsForProductRequest.ReadOnly =
    new Wrapper(impl)
}
