package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeStandardsResponse(
    standards: Option[Iterable[zio.aws.securityhub.model.Standard]] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.DescribeStandardsResponse = {
    import DescribeStandardsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.DescribeStandardsResponse
      .builder()
      .optionallyWith(
        standards.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.standards)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.DescribeStandardsResponse.ReadOnly =
    zio.aws.securityhub.model.DescribeStandardsResponse.wrap(buildAwsValue())
}
object DescribeStandardsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.DescribeStandardsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.DescribeStandardsResponse =
      zio.aws.securityhub.model.DescribeStandardsResponse(
        standards.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def standards: Option[List[zio.aws.securityhub.model.Standard.ReadOnly]]
    def nextToken: Option[NextToken]
    def getStandards: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.Standard.ReadOnly
    ]] = AwsError.unwrapOptionField("standards", standards)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.DescribeStandardsResponse
  ) extends zio.aws.securityhub.model.DescribeStandardsResponse.ReadOnly {
    override val standards
        : Option[List[zio.aws.securityhub.model.Standard.ReadOnly]] = scala
      .Option(impl.standards())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.Standard.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.securityhub.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.DescribeStandardsResponse
  ): zio.aws.securityhub.model.DescribeStandardsResponse.ReadOnly = new Wrapper(
    impl
  )
}
