package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Cvss(
    version: Option[NonEmptyString] = None,
    baseScore: Option[Double] = None,
    baseVector: Option[NonEmptyString] = None,
    source: Option[NonEmptyString] = None,
    adjustments: Option[Iterable[zio.aws.securityhub.model.Adjustment]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.Cvss = {
    import Cvss.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.Cvss
      .builder()
      .optionallyWith(
        version.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.version)
      .optionallyWith(baseScore.map(value => value: java.lang.Double))(
        _.baseScore
      )
      .optionallyWith(
        baseVector.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.baseVector)
      .optionallyWith(
        source.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.source)
      .optionallyWith(
        adjustments.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.adjustments)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.Cvss.ReadOnly =
    zio.aws.securityhub.model.Cvss.wrap(buildAwsValue())
}
object Cvss {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.securityhub.model.Cvss] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.Cvss =
      zio.aws.securityhub.model.Cvss(
        version.map(value => value),
        baseScore.map(value => value),
        baseVector.map(value => value),
        source.map(value => value),
        adjustments.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def version: Option[NonEmptyString]
    def baseScore: Option[Double]
    def baseVector: Option[NonEmptyString]
    def source: Option[NonEmptyString]
    def adjustments: Option[List[zio.aws.securityhub.model.Adjustment.ReadOnly]]
    def getVersion: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("version", version)
    def getBaseScore: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("baseScore", baseScore)
    def getBaseVector: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("baseVector", baseVector)
    def getSource: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("source", source)
    def getAdjustments: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.Adjustment.ReadOnly
    ]] = AwsError.unwrapOptionField("adjustments", adjustments)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.Cvss
  ) extends zio.aws.securityhub.model.Cvss.ReadOnly {
    override val version: Option[NonEmptyString] = scala
      .Option(impl.version())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val baseScore: Option[Double] =
      scala.Option(impl.baseScore()).map(value => value: Double)
    override val baseVector: Option[NonEmptyString] = scala
      .Option(impl.baseVector())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val source: Option[NonEmptyString] = scala
      .Option(impl.source())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val adjustments
        : Option[List[zio.aws.securityhub.model.Adjustment.ReadOnly]] = scala
      .Option(impl.adjustments())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.Adjustment.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.Cvss
  ): zio.aws.securityhub.model.Cvss.ReadOnly = new Wrapper(impl)
}
