package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ClassificationStatus(
    code: Option[NonEmptyString] = None,
    reason: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.ClassificationStatus = {
    import ClassificationStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.ClassificationStatus
      .builder()
      .optionallyWith(
        code.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.code)
      .optionallyWith(
        reason.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.reason)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.ClassificationStatus.ReadOnly =
    zio.aws.securityhub.model.ClassificationStatus.wrap(buildAwsValue())
}
object ClassificationStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.ClassificationStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.ClassificationStatus =
      zio.aws.securityhub.model.ClassificationStatus(
        code.map(value => value),
        reason.map(value => value)
      )
    def code: Option[NonEmptyString]
    def reason: Option[NonEmptyString]
    def getCode: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("code", code)
    def getReason: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("reason", reason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.ClassificationStatus
  ) extends zio.aws.securityhub.model.ClassificationStatus.ReadOnly {
    override val code: Option[NonEmptyString] = scala
      .Option(impl.code())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val reason: Option[NonEmptyString] = scala
      .Option(impl.reason())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.ClassificationStatus
  ): zio.aws.securityhub.model.ClassificationStatus.ReadOnly = new Wrapper(impl)
}
