package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ClassificationResult(
    mimeType: Option[NonEmptyString] = None,
    sizeClassified: Option[Long] = None,
    additionalOccurrences: Option[Boolean] = None,
    status: Option[zio.aws.securityhub.model.ClassificationStatus] = None,
    sensitiveData: Option[
      Iterable[zio.aws.securityhub.model.SensitiveDataResult]
    ] = None,
    customDataIdentifiers: Option[
      zio.aws.securityhub.model.CustomDataIdentifiersResult
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.ClassificationResult = {
    import ClassificationResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.ClassificationResult
      .builder()
      .optionallyWith(
        mimeType.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.mimeType)
      .optionallyWith(sizeClassified.map(value => value: java.lang.Long))(
        _.sizeClassified
      )
      .optionallyWith(
        additionalOccurrences.map(value => value: java.lang.Boolean)
      )(_.additionalOccurrences)
      .optionallyWith(status.map(value => value.buildAwsValue()))(_.status)
      .optionallyWith(
        sensitiveData.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sensitiveData)
      .optionallyWith(
        customDataIdentifiers.map(value => value.buildAwsValue())
      )(_.customDataIdentifiers)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.ClassificationResult.ReadOnly =
    zio.aws.securityhub.model.ClassificationResult.wrap(buildAwsValue())
}
object ClassificationResult {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.ClassificationResult
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.ClassificationResult =
      zio.aws.securityhub.model.ClassificationResult(
        mimeType.map(value => value),
        sizeClassified.map(value => value),
        additionalOccurrences.map(value => value),
        status.map(value => value.asEditable),
        sensitiveData.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        customDataIdentifiers.map(value => value.asEditable)
      )
    def mimeType: Option[NonEmptyString]
    def sizeClassified: Option[Long]
    def additionalOccurrences: Option[Boolean]
    def status: Option[zio.aws.securityhub.model.ClassificationStatus.ReadOnly]
    def sensitiveData
        : Option[List[zio.aws.securityhub.model.SensitiveDataResult.ReadOnly]]
    def customDataIdentifiers
        : Option[zio.aws.securityhub.model.CustomDataIdentifiersResult.ReadOnly]
    def getMimeType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("mimeType", mimeType)
    def getSizeClassified: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("sizeClassified", sizeClassified)
    def getAdditionalOccurrences: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("additionalOccurrences", additionalOccurrences)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.ClassificationStatus.ReadOnly
    ] = AwsError.unwrapOptionField("status", status)
    def getSensitiveData: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.SensitiveDataResult.ReadOnly
    ]] = AwsError.unwrapOptionField("sensitiveData", sensitiveData)
    def getCustomDataIdentifiers: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.CustomDataIdentifiersResult.ReadOnly
    ] =
      AwsError.unwrapOptionField("customDataIdentifiers", customDataIdentifiers)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.ClassificationResult
  ) extends zio.aws.securityhub.model.ClassificationResult.ReadOnly {
    override val mimeType: Option[NonEmptyString] = scala
      .Option(impl.mimeType())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val sizeClassified: Option[Long] =
      scala.Option(impl.sizeClassified()).map(value => value: Long)
    override val additionalOccurrences: Option[Boolean] =
      scala.Option(impl.additionalOccurrences()).map(value => value: Boolean)
    override val status
        : Option[zio.aws.securityhub.model.ClassificationStatus.ReadOnly] =
      scala
        .Option(impl.status())
        .map(value =>
          zio.aws.securityhub.model.ClassificationStatus.wrap(value)
        )
    override val sensitiveData
        : Option[List[zio.aws.securityhub.model.SensitiveDataResult.ReadOnly]] =
      scala
        .Option(impl.sensitiveData())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.SensitiveDataResult.wrap(item)
          }.toList
        )
    override val customDataIdentifiers: Option[
      zio.aws.securityhub.model.CustomDataIdentifiersResult.ReadOnly
    ] = scala
      .Option(impl.customDataIdentifiers())
      .map(value =>
        zio.aws.securityhub.model.CustomDataIdentifiersResult.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.ClassificationResult
  ): zio.aws.securityhub.model.ClassificationResult.ReadOnly = new Wrapper(impl)
}
