package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class City(cityName: Option[NonEmptyString] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.City = {
    import City.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.City
      .builder()
      .optionallyWith(
        cityName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.cityName)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.City.ReadOnly =
    zio.aws.securityhub.model.City.wrap(buildAwsValue())
}
object City {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.securityhub.model.City] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.City =
      zio.aws.securityhub.model.City(cityName.map(value => value))
    def cityName: Option[NonEmptyString]
    def getCityName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("cityName", cityName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.City
  ) extends zio.aws.securityhub.model.City.ReadOnly {
    override val cityName: Option[NonEmptyString] = scala
      .Option(impl.cityName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.City
  ): zio.aws.securityhub.model.City.ReadOnly = new Wrapper(impl)
}
