package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Cell(
    column: Option[Long] = None,
    row: Option[Long] = None,
    columnName: Option[NonEmptyString] = None,
    cellReference: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.Cell = {
    import Cell.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.Cell
      .builder()
      .optionallyWith(column.map(value => value: java.lang.Long))(_.column)
      .optionallyWith(row.map(value => value: java.lang.Long))(_.row)
      .optionallyWith(
        columnName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.columnName)
      .optionallyWith(
        cellReference.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.cellReference)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.Cell.ReadOnly =
    zio.aws.securityhub.model.Cell.wrap(buildAwsValue())
}
object Cell {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.securityhub.model.Cell] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.Cell =
      zio.aws.securityhub.model.Cell(
        column.map(value => value),
        row.map(value => value),
        columnName.map(value => value),
        cellReference.map(value => value)
      )
    def column: Option[Long]
    def row: Option[Long]
    def columnName: Option[NonEmptyString]
    def cellReference: Option[NonEmptyString]
    def getColumn: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("column", column)
    def getRow: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("row", row)
    def getColumnName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("columnName", columnName)
    def getCellReference: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("cellReference", cellReference)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.Cell
  ) extends zio.aws.securityhub.model.Cell.ReadOnly {
    override val column: Option[Long] =
      scala.Option(impl.column()).map(value => value: Long)
    override val row: Option[Long] =
      scala.Option(impl.row()).map(value => value: Long)
    override val columnName: Option[NonEmptyString] = scala
      .Option(impl.columnName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val cellReference: Option[NonEmptyString] = scala
      .Option(impl.cellReference())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.Cell
  ): zio.aws.securityhub.model.Cell.ReadOnly = new Wrapper(impl)
}
