package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsWafRateBasedRuleDetails(
    metricName: Option[NonEmptyString] = None,
    name: Option[NonEmptyString] = None,
    rateKey: Option[NonEmptyString] = None,
    rateLimit: Option[Long] = None,
    ruleId: Option[NonEmptyString] = None,
    matchPredicates: Option[
      Iterable[zio.aws.securityhub.model.AwsWafRateBasedRuleMatchPredicate]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsWafRateBasedRuleDetails = {
    import AwsWafRateBasedRuleDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsWafRateBasedRuleDetails
      .builder()
      .optionallyWith(
        metricName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.metricName)
      .optionallyWith(
        name.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        rateKey.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.rateKey)
      .optionallyWith(rateLimit.map(value => value: java.lang.Long))(
        _.rateLimit
      )
      .optionallyWith(
        ruleId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.ruleId)
      .optionallyWith(
        matchPredicates.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.matchPredicates)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsWafRateBasedRuleDetails.ReadOnly =
    zio.aws.securityhub.model.AwsWafRateBasedRuleDetails.wrap(buildAwsValue())
}
object AwsWafRateBasedRuleDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsWafRateBasedRuleDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsWafRateBasedRuleDetails =
      zio.aws.securityhub.model.AwsWafRateBasedRuleDetails(
        metricName.map(value => value),
        name.map(value => value),
        rateKey.map(value => value),
        rateLimit.map(value => value),
        ruleId.map(value => value),
        matchPredicates.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def metricName: Option[NonEmptyString]
    def name: Option[NonEmptyString]
    def rateKey: Option[NonEmptyString]
    def rateLimit: Option[Long]
    def ruleId: Option[NonEmptyString]
    def matchPredicates: Option[
      List[zio.aws.securityhub.model.AwsWafRateBasedRuleMatchPredicate.ReadOnly]
    ]
    def getMetricName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("metricName", metricName)
    def getName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("name", name)
    def getRateKey: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("rateKey", rateKey)
    def getRateLimit: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("rateLimit", rateLimit)
    def getRuleId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("ruleId", ruleId)
    def getMatchPredicates: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsWafRateBasedRuleMatchPredicate.ReadOnly
    ]] = AwsError.unwrapOptionField("matchPredicates", matchPredicates)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsWafRateBasedRuleDetails
  ) extends zio.aws.securityhub.model.AwsWafRateBasedRuleDetails.ReadOnly {
    override val metricName: Option[NonEmptyString] = scala
      .Option(impl.metricName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val name: Option[NonEmptyString] = scala
      .Option(impl.name())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val rateKey: Option[NonEmptyString] = scala
      .Option(impl.rateKey())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val rateLimit: Option[Long] =
      scala.Option(impl.rateLimit()).map(value => value: Long)
    override val ruleId: Option[NonEmptyString] = scala
      .Option(impl.ruleId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val matchPredicates: Option[
      List[zio.aws.securityhub.model.AwsWafRateBasedRuleMatchPredicate.ReadOnly]
    ] = scala
      .Option(impl.matchPredicates())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsWafRateBasedRuleMatchPredicate.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsWafRateBasedRuleDetails
  ): zio.aws.securityhub.model.AwsWafRateBasedRuleDetails.ReadOnly =
    new Wrapper(impl)
}
