package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateDetails(
    operands: Option[Iterable[
      zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsDetails
    ]] = None,
    prefix: Option[NonEmptyString] = None,
    tag: Option[
      zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateTagDetails
    ] = None,
    `type`: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateDetails = {
    import AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateDetails
      .builder()
      .optionallyWith(
        operands.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.operands)
      .optionallyWith(
        prefix.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.prefix)
      .optionallyWith(tag.map(value => value.buildAwsValue()))(_.tag)
      .optionallyWith(
        `type`.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.`type`)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateDetails.ReadOnly =
    zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateDetails
      .wrap(buildAwsValue())
}
object AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateDetails =
      zio.aws.securityhub.model
        .AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateDetails(
          operands.map(value =>
            value.map { item =>
              item.asEditable
            }
          ),
          prefix.map(value => value),
          tag.map(value => value.asEditable),
          `type`.map(value => value)
        )
    def operands: Option[List[
      zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsDetails.ReadOnly
    ]]
    def prefix: Option[NonEmptyString]
    def tag: Option[
      zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateTagDetails.ReadOnly
    ]
    def `type`: Option[NonEmptyString]
    def getOperands: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsDetails.ReadOnly
    ]] = AwsError.unwrapOptionField("operands", operands)
    def getPrefix: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("prefix", prefix)
    def getTag: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateTagDetails.ReadOnly
    ] = AwsError.unwrapOptionField("tag", tag)
    def getType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateDetails
  ) extends zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateDetails.ReadOnly {
    override val operands: Option[List[
      zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsDetails.ReadOnly
    ]] = scala
      .Option(impl.operands())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsDetails
            .wrap(item)
        }.toList
      )
    override val prefix: Option[NonEmptyString] = scala
      .Option(impl.prefix())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val tag: Option[
      zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateTagDetails.ReadOnly
    ] = scala
      .Option(impl.tag())
      .map(value =>
        zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateTagDetails
          .wrap(value)
      )
    override val `type`: Option[NonEmptyString] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateDetails
  ): zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateDetails.ReadOnly =
    new Wrapper(impl)
}
