package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{Integer, NonEmptyString}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsS3BucketBucketLifecycleConfigurationRulesDetails(
    abortIncompleteMultipartUpload: Option[
      zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesAbortIncompleteMultipartUploadDetails
    ] = None,
    expirationDate: Option[NonEmptyString] = None,
    expirationInDays: Option[Integer] = None,
    expiredObjectDeleteMarker: Option[Boolean] = None,
    filter: Option[
      zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesFilterDetails
    ] = None,
    id: Option[NonEmptyString] = None,
    noncurrentVersionExpirationInDays: Option[Integer] = None,
    noncurrentVersionTransitions: Option[Iterable[
      zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesNoncurrentVersionTransitionsDetails
    ]] = None,
    prefix: Option[NonEmptyString] = None,
    status: Option[NonEmptyString] = None,
    transitions: Option[Iterable[
      zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesTransitionsDetails
    ]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesDetails = {
    import AwsS3BucketBucketLifecycleConfigurationRulesDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesDetails
      .builder()
      .optionallyWith(
        abortIncompleteMultipartUpload.map(value => value.buildAwsValue())
      )(_.abortIncompleteMultipartUpload)
      .optionallyWith(
        expirationDate.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.expirationDate)
      .optionallyWith(
        expirationInDays.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.expirationInDays)
      .optionallyWith(
        expiredObjectDeleteMarker.map(value => value: java.lang.Boolean)
      )(_.expiredObjectDeleteMarker)
      .optionallyWith(filter.map(value => value.buildAwsValue()))(_.filter)
      .optionallyWith(
        id.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        noncurrentVersionExpirationInDays.map(value =>
          Integer.unwrap(value): java.lang.Integer
        )
      )(_.noncurrentVersionExpirationInDays)
      .optionallyWith(
        noncurrentVersionTransitions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.noncurrentVersionTransitions)
      .optionallyWith(
        prefix.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.prefix)
      .optionallyWith(
        status.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.status)
      .optionallyWith(
        transitions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.transitions)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesDetails.ReadOnly =
    zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesDetails
      .wrap(buildAwsValue())
}
object AwsS3BucketBucketLifecycleConfigurationRulesDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesDetails =
      zio.aws.securityhub.model
        .AwsS3BucketBucketLifecycleConfigurationRulesDetails(
          abortIncompleteMultipartUpload.map(value => value.asEditable),
          expirationDate.map(value => value),
          expirationInDays.map(value => value),
          expiredObjectDeleteMarker.map(value => value),
          filter.map(value => value.asEditable),
          id.map(value => value),
          noncurrentVersionExpirationInDays.map(value => value),
          noncurrentVersionTransitions.map(value =>
            value.map { item =>
              item.asEditable
            }
          ),
          prefix.map(value => value),
          status.map(value => value),
          transitions.map(value =>
            value.map { item =>
              item.asEditable
            }
          )
        )
    def abortIncompleteMultipartUpload: Option[
      zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesAbortIncompleteMultipartUploadDetails.ReadOnly
    ]
    def expirationDate: Option[NonEmptyString]
    def expirationInDays: Option[Integer]
    def expiredObjectDeleteMarker: Option[Boolean]
    def filter: Option[
      zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesFilterDetails.ReadOnly
    ]
    def id: Option[NonEmptyString]
    def noncurrentVersionExpirationInDays: Option[Integer]
    def noncurrentVersionTransitions: Option[List[
      zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesNoncurrentVersionTransitionsDetails.ReadOnly
    ]]
    def prefix: Option[NonEmptyString]
    def status: Option[NonEmptyString]
    def transitions: Option[List[
      zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesTransitionsDetails.ReadOnly
    ]]
    def getAbortIncompleteMultipartUpload: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesAbortIncompleteMultipartUploadDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "abortIncompleteMultipartUpload",
      abortIncompleteMultipartUpload
    )
    def getExpirationDate: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("expirationDate", expirationDate)
    def getExpirationInDays: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("expirationInDays", expirationInDays)
    def getExpiredObjectDeleteMarker: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("expiredObjectDeleteMarker", expiredObjectDeleteMarker)
    def getFilter: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesFilterDetails.ReadOnly
    ] = AwsError.unwrapOptionField("filter", filter)
    def getId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("id", id)
    def getNoncurrentVersionExpirationInDays: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField(
        "noncurrentVersionExpirationInDays",
        noncurrentVersionExpirationInDays
      )
    def getNoncurrentVersionTransitions: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesNoncurrentVersionTransitionsDetails.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "noncurrentVersionTransitions",
      noncurrentVersionTransitions
    )
    def getPrefix: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("prefix", prefix)
    def getStatus: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("status", status)
    def getTransitions: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesTransitionsDetails.ReadOnly
    ]] = AwsError.unwrapOptionField("transitions", transitions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesDetails
  ) extends zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesDetails.ReadOnly {
    override val abortIncompleteMultipartUpload: Option[
      zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesAbortIncompleteMultipartUploadDetails.ReadOnly
    ] = scala
      .Option(impl.abortIncompleteMultipartUpload())
      .map(value =>
        zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesAbortIncompleteMultipartUploadDetails
          .wrap(value)
      )
    override val expirationDate: Option[NonEmptyString] = scala
      .Option(impl.expirationDate())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val expirationInDays: Option[Integer] = scala
      .Option(impl.expirationInDays())
      .map(value => zio.aws.securityhub.model.primitives.Integer(value))
    override val expiredObjectDeleteMarker: Option[Boolean] = scala
      .Option(impl.expiredObjectDeleteMarker())
      .map(value => value: Boolean)
    override val filter: Option[
      zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesFilterDetails.ReadOnly
    ] = scala
      .Option(impl.filter())
      .map(value =>
        zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesFilterDetails
          .wrap(value)
      )
    override val id: Option[NonEmptyString] = scala
      .Option(impl.id())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val noncurrentVersionExpirationInDays: Option[Integer] = scala
      .Option(impl.noncurrentVersionExpirationInDays())
      .map(value => zio.aws.securityhub.model.primitives.Integer(value))
    override val noncurrentVersionTransitions: Option[List[
      zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesNoncurrentVersionTransitionsDetails.ReadOnly
    ]] = scala
      .Option(impl.noncurrentVersionTransitions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesNoncurrentVersionTransitionsDetails
            .wrap(item)
        }.toList
      )
    override val prefix: Option[NonEmptyString] = scala
      .Option(impl.prefix())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val status: Option[NonEmptyString] = scala
      .Option(impl.status())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val transitions: Option[List[
      zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesTransitionsDetails.ReadOnly
    ]] = scala
      .Option(impl.transitions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesTransitionsDetails
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesDetails
  ): zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesDetails.ReadOnly =
    new Wrapper(impl)
}
