package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsS3AccountPublicAccessBlockDetails(
    blockPublicAcls: Option[Boolean] = None,
    blockPublicPolicy: Option[Boolean] = None,
    ignorePublicAcls: Option[Boolean] = None,
    restrictPublicBuckets: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsS3AccountPublicAccessBlockDetails = {
    import AwsS3AccountPublicAccessBlockDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsS3AccountPublicAccessBlockDetails
      .builder()
      .optionallyWith(blockPublicAcls.map(value => value: java.lang.Boolean))(
        _.blockPublicAcls
      )
      .optionallyWith(blockPublicPolicy.map(value => value: java.lang.Boolean))(
        _.blockPublicPolicy
      )
      .optionallyWith(ignorePublicAcls.map(value => value: java.lang.Boolean))(
        _.ignorePublicAcls
      )
      .optionallyWith(
        restrictPublicBuckets.map(value => value: java.lang.Boolean)
      )(_.restrictPublicBuckets)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsS3AccountPublicAccessBlockDetails.ReadOnly =
    zio.aws.securityhub.model.AwsS3AccountPublicAccessBlockDetails
      .wrap(buildAwsValue())
}
object AwsS3AccountPublicAccessBlockDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsS3AccountPublicAccessBlockDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsS3AccountPublicAccessBlockDetails =
      zio.aws.securityhub.model.AwsS3AccountPublicAccessBlockDetails(
        blockPublicAcls.map(value => value),
        blockPublicPolicy.map(value => value),
        ignorePublicAcls.map(value => value),
        restrictPublicBuckets.map(value => value)
      )
    def blockPublicAcls: Option[Boolean]
    def blockPublicPolicy: Option[Boolean]
    def ignorePublicAcls: Option[Boolean]
    def restrictPublicBuckets: Option[Boolean]
    def getBlockPublicAcls: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("blockPublicAcls", blockPublicAcls)
    def getBlockPublicPolicy: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("blockPublicPolicy", blockPublicPolicy)
    def getIgnorePublicAcls: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("ignorePublicAcls", ignorePublicAcls)
    def getRestrictPublicBuckets: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("restrictPublicBuckets", restrictPublicBuckets)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsS3AccountPublicAccessBlockDetails
  ) extends zio.aws.securityhub.model.AwsS3AccountPublicAccessBlockDetails.ReadOnly {
    override val blockPublicAcls: Option[Boolean] =
      scala.Option(impl.blockPublicAcls()).map(value => value: Boolean)
    override val blockPublicPolicy: Option[Boolean] =
      scala.Option(impl.blockPublicPolicy()).map(value => value: Boolean)
    override val ignorePublicAcls: Option[Boolean] =
      scala.Option(impl.ignorePublicAcls()).map(value => value: Boolean)
    override val restrictPublicBuckets: Option[Boolean] =
      scala.Option(impl.restrictPublicBuckets()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsS3AccountPublicAccessBlockDetails
  ): zio.aws.securityhub.model.AwsS3AccountPublicAccessBlockDetails.ReadOnly =
    new Wrapper(impl)
}
