package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsRdsDbSubnetGroup(
    dbSubnetGroupName: Option[NonEmptyString] = None,
    dbSubnetGroupDescription: Option[NonEmptyString] = None,
    vpcId: Option[NonEmptyString] = None,
    subnetGroupStatus: Option[NonEmptyString] = None,
    subnets: Option[
      Iterable[zio.aws.securityhub.model.AwsRdsDbSubnetGroupSubnet]
    ] = None,
    dbSubnetGroupArn: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsRdsDbSubnetGroup = {
    import AwsRdsDbSubnetGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsRdsDbSubnetGroup
      .builder()
      .optionallyWith(
        dbSubnetGroupName.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.dbSubnetGroupName)
      .optionallyWith(
        dbSubnetGroupDescription.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.dbSubnetGroupDescription)
      .optionallyWith(
        vpcId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.vpcId)
      .optionallyWith(
        subnetGroupStatus.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.subnetGroupStatus)
      .optionallyWith(
        subnets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.subnets)
      .optionallyWith(
        dbSubnetGroupArn.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.dbSubnetGroupArn)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.AwsRdsDbSubnetGroup.ReadOnly =
    zio.aws.securityhub.model.AwsRdsDbSubnetGroup.wrap(buildAwsValue())
}
object AwsRdsDbSubnetGroup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsRdsDbSubnetGroup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsRdsDbSubnetGroup =
      zio.aws.securityhub.model.AwsRdsDbSubnetGroup(
        dbSubnetGroupName.map(value => value),
        dbSubnetGroupDescription.map(value => value),
        vpcId.map(value => value),
        subnetGroupStatus.map(value => value),
        subnets.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        dbSubnetGroupArn.map(value => value)
      )
    def dbSubnetGroupName: Option[NonEmptyString]
    def dbSubnetGroupDescription: Option[NonEmptyString]
    def vpcId: Option[NonEmptyString]
    def subnetGroupStatus: Option[NonEmptyString]
    def subnets: Option[
      List[zio.aws.securityhub.model.AwsRdsDbSubnetGroupSubnet.ReadOnly]
    ]
    def dbSubnetGroupArn: Option[NonEmptyString]
    def getDbSubnetGroupName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("dbSubnetGroupName", dbSubnetGroupName)
    def getDbSubnetGroupDescription: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField(
        "dbSubnetGroupDescription",
        dbSubnetGroupDescription
      )
    def getVpcId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getSubnetGroupStatus: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("subnetGroupStatus", subnetGroupStatus)
    def getSubnets: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsRdsDbSubnetGroupSubnet.ReadOnly
    ]] = AwsError.unwrapOptionField("subnets", subnets)
    def getDbSubnetGroupArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("dbSubnetGroupArn", dbSubnetGroupArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsRdsDbSubnetGroup
  ) extends zio.aws.securityhub.model.AwsRdsDbSubnetGroup.ReadOnly {
    override val dbSubnetGroupName: Option[NonEmptyString] = scala
      .Option(impl.dbSubnetGroupName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val dbSubnetGroupDescription: Option[NonEmptyString] = scala
      .Option(impl.dbSubnetGroupDescription())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val vpcId: Option[NonEmptyString] = scala
      .Option(impl.vpcId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val subnetGroupStatus: Option[NonEmptyString] = scala
      .Option(impl.subnetGroupStatus())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val subnets: Option[
      List[zio.aws.securityhub.model.AwsRdsDbSubnetGroupSubnet.ReadOnly]
    ] = scala
      .Option(impl.subnets())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsRdsDbSubnetGroupSubnet.wrap(item)
        }.toList
      )
    override val dbSubnetGroupArn: Option[NonEmptyString] = scala
      .Option(impl.dbSubnetGroupArn())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsRdsDbSubnetGroup
  ): zio.aws.securityhub.model.AwsRdsDbSubnetGroup.ReadOnly = new Wrapper(impl)
}
