package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{Integer, NonEmptyString}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsRdsDbPendingModifiedValues(
    dbInstanceClass: Option[NonEmptyString] = None,
    allocatedStorage: Option[Integer] = None,
    masterUserPassword: Option[NonEmptyString] = None,
    port: Option[Integer] = None,
    backupRetentionPeriod: Option[Integer] = None,
    multiAZ: Option[Boolean] = None,
    engineVersion: Option[NonEmptyString] = None,
    licenseModel: Option[NonEmptyString] = None,
    iops: Option[Integer] = None,
    dbInstanceIdentifier: Option[NonEmptyString] = None,
    storageType: Option[NonEmptyString] = None,
    caCertificateIdentifier: Option[NonEmptyString] = None,
    dbSubnetGroupName: Option[NonEmptyString] = None,
    pendingCloudWatchLogsExports: Option[
      zio.aws.securityhub.model.AwsRdsPendingCloudWatchLogsExports
    ] = None,
    processorFeatures: Option[
      Iterable[zio.aws.securityhub.model.AwsRdsDbProcessorFeature]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsRdsDbPendingModifiedValues = {
    import AwsRdsDbPendingModifiedValues.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsRdsDbPendingModifiedValues
      .builder()
      .optionallyWith(
        dbInstanceClass.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.dbInstanceClass)
      .optionallyWith(
        allocatedStorage.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.allocatedStorage)
      .optionallyWith(
        masterUserPassword.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.masterUserPassword)
      .optionallyWith(
        port.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.port)
      .optionallyWith(
        backupRetentionPeriod.map(value =>
          Integer.unwrap(value): java.lang.Integer
        )
      )(_.backupRetentionPeriod)
      .optionallyWith(multiAZ.map(value => value: java.lang.Boolean))(_.multiAZ)
      .optionallyWith(
        engineVersion.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.engineVersion)
      .optionallyWith(
        licenseModel.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.licenseModel)
      .optionallyWith(
        iops.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.iops)
      .optionallyWith(
        dbInstanceIdentifier.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.dbInstanceIdentifier)
      .optionallyWith(
        storageType.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.storageType)
      .optionallyWith(
        caCertificateIdentifier.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.caCertificateIdentifier)
      .optionallyWith(
        dbSubnetGroupName.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.dbSubnetGroupName)
      .optionallyWith(
        pendingCloudWatchLogsExports.map(value => value.buildAwsValue())
      )(_.pendingCloudWatchLogsExports)
      .optionallyWith(
        processorFeatures.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.processorFeatures)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsRdsDbPendingModifiedValues.ReadOnly =
    zio.aws.securityhub.model.AwsRdsDbPendingModifiedValues
      .wrap(buildAwsValue())
}
object AwsRdsDbPendingModifiedValues {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsRdsDbPendingModifiedValues
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsRdsDbPendingModifiedValues =
      zio.aws.securityhub.model.AwsRdsDbPendingModifiedValues(
        dbInstanceClass.map(value => value),
        allocatedStorage.map(value => value),
        masterUserPassword.map(value => value),
        port.map(value => value),
        backupRetentionPeriod.map(value => value),
        multiAZ.map(value => value),
        engineVersion.map(value => value),
        licenseModel.map(value => value),
        iops.map(value => value),
        dbInstanceIdentifier.map(value => value),
        storageType.map(value => value),
        caCertificateIdentifier.map(value => value),
        dbSubnetGroupName.map(value => value),
        pendingCloudWatchLogsExports.map(value => value.asEditable),
        processorFeatures.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def dbInstanceClass: Option[NonEmptyString]
    def allocatedStorage: Option[Integer]
    def masterUserPassword: Option[NonEmptyString]
    def port: Option[Integer]
    def backupRetentionPeriod: Option[Integer]
    def multiAZ: Option[Boolean]
    def engineVersion: Option[NonEmptyString]
    def licenseModel: Option[NonEmptyString]
    def iops: Option[Integer]
    def dbInstanceIdentifier: Option[NonEmptyString]
    def storageType: Option[NonEmptyString]
    def caCertificateIdentifier: Option[NonEmptyString]
    def dbSubnetGroupName: Option[NonEmptyString]
    def pendingCloudWatchLogsExports: Option[
      zio.aws.securityhub.model.AwsRdsPendingCloudWatchLogsExports.ReadOnly
    ]
    def processorFeatures: Option[
      List[zio.aws.securityhub.model.AwsRdsDbProcessorFeature.ReadOnly]
    ]
    def getDbInstanceClass: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("dbInstanceClass", dbInstanceClass)
    def getAllocatedStorage: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("allocatedStorage", allocatedStorage)
    def getMasterUserPassword: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("masterUserPassword", masterUserPassword)
    def getPort: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("port", port)
    def getBackupRetentionPeriod: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("backupRetentionPeriod", backupRetentionPeriod)
    def getMultiAZ: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("multiAZ", multiAZ)
    def getEngineVersion: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getLicenseModel: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("licenseModel", licenseModel)
    def getIops: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("iops", iops)
    def getDbInstanceIdentifier: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("dbInstanceIdentifier", dbInstanceIdentifier)
    def getStorageType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("storageType", storageType)
    def getCaCertificateIdentifier: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField(
        "caCertificateIdentifier",
        caCertificateIdentifier
      )
    def getDbSubnetGroupName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("dbSubnetGroupName", dbSubnetGroupName)
    def getPendingCloudWatchLogsExports: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsRdsPendingCloudWatchLogsExports.ReadOnly
    ] = AwsError.unwrapOptionField(
      "pendingCloudWatchLogsExports",
      pendingCloudWatchLogsExports
    )
    def getProcessorFeatures: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsRdsDbProcessorFeature.ReadOnly
    ]] = AwsError.unwrapOptionField("processorFeatures", processorFeatures)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsRdsDbPendingModifiedValues
  ) extends zio.aws.securityhub.model.AwsRdsDbPendingModifiedValues.ReadOnly {
    override val dbInstanceClass: Option[NonEmptyString] = scala
      .Option(impl.dbInstanceClass())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val allocatedStorage: Option[Integer] = scala
      .Option(impl.allocatedStorage())
      .map(value => zio.aws.securityhub.model.primitives.Integer(value))
    override val masterUserPassword: Option[NonEmptyString] = scala
      .Option(impl.masterUserPassword())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val port: Option[Integer] = scala
      .Option(impl.port())
      .map(value => zio.aws.securityhub.model.primitives.Integer(value))
    override val backupRetentionPeriod: Option[Integer] = scala
      .Option(impl.backupRetentionPeriod())
      .map(value => zio.aws.securityhub.model.primitives.Integer(value))
    override val multiAZ: Option[Boolean] =
      scala.Option(impl.multiAZ()).map(value => value: Boolean)
    override val engineVersion: Option[NonEmptyString] = scala
      .Option(impl.engineVersion())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val licenseModel: Option[NonEmptyString] = scala
      .Option(impl.licenseModel())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val iops: Option[Integer] = scala
      .Option(impl.iops())
      .map(value => zio.aws.securityhub.model.primitives.Integer(value))
    override val dbInstanceIdentifier: Option[NonEmptyString] = scala
      .Option(impl.dbInstanceIdentifier())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val storageType: Option[NonEmptyString] = scala
      .Option(impl.storageType())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val caCertificateIdentifier: Option[NonEmptyString] = scala
      .Option(impl.caCertificateIdentifier())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val dbSubnetGroupName: Option[NonEmptyString] = scala
      .Option(impl.dbSubnetGroupName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val pendingCloudWatchLogsExports: Option[
      zio.aws.securityhub.model.AwsRdsPendingCloudWatchLogsExports.ReadOnly
    ] = scala
      .Option(impl.pendingCloudWatchLogsExports())
      .map(value =>
        zio.aws.securityhub.model.AwsRdsPendingCloudWatchLogsExports.wrap(value)
      )
    override val processorFeatures: Option[
      List[zio.aws.securityhub.model.AwsRdsDbProcessorFeature.ReadOnly]
    ] = scala
      .Option(impl.processorFeatures())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsRdsDbProcessorFeature.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsRdsDbPendingModifiedValues
  ): zio.aws.securityhub.model.AwsRdsDbPendingModifiedValues.ReadOnly =
    new Wrapper(impl)
}
