package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsRdsDbClusterAssociatedRole(
    roleArn: Option[NonEmptyString] = None,
    status: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsRdsDbClusterAssociatedRole = {
    import AwsRdsDbClusterAssociatedRole.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsRdsDbClusterAssociatedRole
      .builder()
      .optionallyWith(
        roleArn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(
        status.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.status)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsRdsDbClusterAssociatedRole.ReadOnly =
    zio.aws.securityhub.model.AwsRdsDbClusterAssociatedRole
      .wrap(buildAwsValue())
}
object AwsRdsDbClusterAssociatedRole {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsRdsDbClusterAssociatedRole
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsRdsDbClusterAssociatedRole =
      zio.aws.securityhub.model.AwsRdsDbClusterAssociatedRole(
        roleArn.map(value => value),
        status.map(value => value)
      )
    def roleArn: Option[NonEmptyString]
    def status: Option[NonEmptyString]
    def getRoleArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getStatus: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsRdsDbClusterAssociatedRole
  ) extends zio.aws.securityhub.model.AwsRdsDbClusterAssociatedRole.ReadOnly {
    override val roleArn: Option[NonEmptyString] = scala
      .Option(impl.roleArn())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val status: Option[NonEmptyString] = scala
      .Option(impl.status())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsRdsDbClusterAssociatedRole
  ): zio.aws.securityhub.model.AwsRdsDbClusterAssociatedRole.ReadOnly =
    new Wrapper(impl)
}
