package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsOpenSearchServiceDomainLogPublishingOptionsDetails(
    indexSlowLogs: Option[
      zio.aws.securityhub.model.AwsOpenSearchServiceDomainLogPublishingOption
    ] = None,
    searchSlowLogs: Option[
      zio.aws.securityhub.model.AwsOpenSearchServiceDomainLogPublishingOption
    ] = None,
    auditLogs: Option[
      zio.aws.securityhub.model.AwsOpenSearchServiceDomainLogPublishingOption
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsOpenSearchServiceDomainLogPublishingOptionsDetails = {
    import AwsOpenSearchServiceDomainLogPublishingOptionsDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsOpenSearchServiceDomainLogPublishingOptionsDetails
      .builder()
      .optionallyWith(indexSlowLogs.map(value => value.buildAwsValue()))(
        _.indexSlowLogs
      )
      .optionallyWith(searchSlowLogs.map(value => value.buildAwsValue()))(
        _.searchSlowLogs
      )
      .optionallyWith(auditLogs.map(value => value.buildAwsValue()))(
        _.auditLogs
      )
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsOpenSearchServiceDomainLogPublishingOptionsDetails.ReadOnly =
    zio.aws.securityhub.model.AwsOpenSearchServiceDomainLogPublishingOptionsDetails
      .wrap(buildAwsValue())
}
object AwsOpenSearchServiceDomainLogPublishingOptionsDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsOpenSearchServiceDomainLogPublishingOptionsDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsOpenSearchServiceDomainLogPublishingOptionsDetails =
      zio.aws.securityhub.model
        .AwsOpenSearchServiceDomainLogPublishingOptionsDetails(
          indexSlowLogs.map(value => value.asEditable),
          searchSlowLogs.map(value => value.asEditable),
          auditLogs.map(value => value.asEditable)
        )
    def indexSlowLogs: Option[
      zio.aws.securityhub.model.AwsOpenSearchServiceDomainLogPublishingOption.ReadOnly
    ]
    def searchSlowLogs: Option[
      zio.aws.securityhub.model.AwsOpenSearchServiceDomainLogPublishingOption.ReadOnly
    ]
    def auditLogs: Option[
      zio.aws.securityhub.model.AwsOpenSearchServiceDomainLogPublishingOption.ReadOnly
    ]
    def getIndexSlowLogs: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsOpenSearchServiceDomainLogPublishingOption.ReadOnly
    ] = AwsError.unwrapOptionField("indexSlowLogs", indexSlowLogs)
    def getSearchSlowLogs: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsOpenSearchServiceDomainLogPublishingOption.ReadOnly
    ] = AwsError.unwrapOptionField("searchSlowLogs", searchSlowLogs)
    def getAuditLogs: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsOpenSearchServiceDomainLogPublishingOption.ReadOnly
    ] = AwsError.unwrapOptionField("auditLogs", auditLogs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsOpenSearchServiceDomainLogPublishingOptionsDetails
  ) extends zio.aws.securityhub.model.AwsOpenSearchServiceDomainLogPublishingOptionsDetails.ReadOnly {
    override val indexSlowLogs: Option[
      zio.aws.securityhub.model.AwsOpenSearchServiceDomainLogPublishingOption.ReadOnly
    ] = scala
      .Option(impl.indexSlowLogs())
      .map(value =>
        zio.aws.securityhub.model.AwsOpenSearchServiceDomainLogPublishingOption
          .wrap(value)
      )
    override val searchSlowLogs: Option[
      zio.aws.securityhub.model.AwsOpenSearchServiceDomainLogPublishingOption.ReadOnly
    ] = scala
      .Option(impl.searchSlowLogs())
      .map(value =>
        zio.aws.securityhub.model.AwsOpenSearchServiceDomainLogPublishingOption
          .wrap(value)
      )
    override val auditLogs: Option[
      zio.aws.securityhub.model.AwsOpenSearchServiceDomainLogPublishingOption.ReadOnly
    ] = scala
      .Option(impl.auditLogs())
      .map(value =>
        zio.aws.securityhub.model.AwsOpenSearchServiceDomainLogPublishingOption
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsOpenSearchServiceDomainLogPublishingOptionsDetails
  ): zio.aws.securityhub.model.AwsOpenSearchServiceDomainLogPublishingOptionsDetails.ReadOnly =
    new Wrapper(impl)
}
