package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsOpenSearchServiceDomainEncryptionAtRestOptionsDetails(
    enabled: Option[Boolean] = None,
    kmsKeyId: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsOpenSearchServiceDomainEncryptionAtRestOptionsDetails = {
    import AwsOpenSearchServiceDomainEncryptionAtRestOptionsDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsOpenSearchServiceDomainEncryptionAtRestOptionsDetails
      .builder()
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .optionallyWith(
        kmsKeyId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsOpenSearchServiceDomainEncryptionAtRestOptionsDetails.ReadOnly =
    zio.aws.securityhub.model.AwsOpenSearchServiceDomainEncryptionAtRestOptionsDetails
      .wrap(buildAwsValue())
}
object AwsOpenSearchServiceDomainEncryptionAtRestOptionsDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsOpenSearchServiceDomainEncryptionAtRestOptionsDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsOpenSearchServiceDomainEncryptionAtRestOptionsDetails =
      zio.aws.securityhub.model
        .AwsOpenSearchServiceDomainEncryptionAtRestOptionsDetails(
          enabled.map(value => value),
          kmsKeyId.map(value => value)
        )
    def enabled: Option[Boolean]
    def kmsKeyId: Option[NonEmptyString]
    def getEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
    def getKmsKeyId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsOpenSearchServiceDomainEncryptionAtRestOptionsDetails
  ) extends zio.aws.securityhub.model.AwsOpenSearchServiceDomainEncryptionAtRestOptionsDetails.ReadOnly {
    override val enabled: Option[Boolean] =
      scala.Option(impl.enabled()).map(value => value: Boolean)
    override val kmsKeyId: Option[NonEmptyString] = scala
      .Option(impl.kmsKeyId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsOpenSearchServiceDomainEncryptionAtRestOptionsDetails
  ): zio.aws.securityhub.model.AwsOpenSearchServiceDomainEncryptionAtRestOptionsDetails.ReadOnly =
    new Wrapper(impl)
}
