package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsOpenSearchServiceDomainDomainEndpointOptionsDetails(
    customEndpointCertificateArn: Option[NonEmptyString] = None,
    customEndpointEnabled: Option[Boolean] = None,
    enforceHTTPS: Option[Boolean] = None,
    customEndpoint: Option[NonEmptyString] = None,
    tlsSecurityPolicy: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsOpenSearchServiceDomainDomainEndpointOptionsDetails = {
    import AwsOpenSearchServiceDomainDomainEndpointOptionsDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsOpenSearchServiceDomainDomainEndpointOptionsDetails
      .builder()
      .optionallyWith(
        customEndpointCertificateArn.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.customEndpointCertificateArn)
      .optionallyWith(
        customEndpointEnabled.map(value => value: java.lang.Boolean)
      )(_.customEndpointEnabled)
      .optionallyWith(enforceHTTPS.map(value => value: java.lang.Boolean))(
        _.enforceHTTPS
      )
      .optionallyWith(
        customEndpoint.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.customEndpoint)
      .optionallyWith(
        tlsSecurityPolicy.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.tlsSecurityPolicy)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsOpenSearchServiceDomainDomainEndpointOptionsDetails.ReadOnly =
    zio.aws.securityhub.model.AwsOpenSearchServiceDomainDomainEndpointOptionsDetails
      .wrap(buildAwsValue())
}
object AwsOpenSearchServiceDomainDomainEndpointOptionsDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsOpenSearchServiceDomainDomainEndpointOptionsDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsOpenSearchServiceDomainDomainEndpointOptionsDetails =
      zio.aws.securityhub.model
        .AwsOpenSearchServiceDomainDomainEndpointOptionsDetails(
          customEndpointCertificateArn.map(value => value),
          customEndpointEnabled.map(value => value),
          enforceHTTPS.map(value => value),
          customEndpoint.map(value => value),
          tlsSecurityPolicy.map(value => value)
        )
    def customEndpointCertificateArn: Option[NonEmptyString]
    def customEndpointEnabled: Option[Boolean]
    def enforceHTTPS: Option[Boolean]
    def customEndpoint: Option[NonEmptyString]
    def tlsSecurityPolicy: Option[NonEmptyString]
    def getCustomEndpointCertificateArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField(
        "customEndpointCertificateArn",
        customEndpointCertificateArn
      )
    def getCustomEndpointEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("customEndpointEnabled", customEndpointEnabled)
    def getEnforceHTTPS: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enforceHTTPS", enforceHTTPS)
    def getCustomEndpoint: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("customEndpoint", customEndpoint)
    def getTlsSecurityPolicy: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("tlsSecurityPolicy", tlsSecurityPolicy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsOpenSearchServiceDomainDomainEndpointOptionsDetails
  ) extends zio.aws.securityhub.model.AwsOpenSearchServiceDomainDomainEndpointOptionsDetails.ReadOnly {
    override val customEndpointCertificateArn: Option[NonEmptyString] = scala
      .Option(impl.customEndpointCertificateArn())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val customEndpointEnabled: Option[Boolean] =
      scala.Option(impl.customEndpointEnabled()).map(value => value: Boolean)
    override val enforceHTTPS: Option[Boolean] =
      scala.Option(impl.enforceHTTPS()).map(value => value: Boolean)
    override val customEndpoint: Option[NonEmptyString] = scala
      .Option(impl.customEndpoint())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val tlsSecurityPolicy: Option[NonEmptyString] = scala
      .Option(impl.tlsSecurityPolicy())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsOpenSearchServiceDomainDomainEndpointOptionsDetails
  ): zio.aws.securityhub.model.AwsOpenSearchServiceDomainDomainEndpointOptionsDetails.ReadOnly =
    new Wrapper(impl)
}
