package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{
  NonEmptyString,
  AwsLambdaLayerVersionNumber
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsLambdaLayerVersionDetails(
    version: Option[AwsLambdaLayerVersionNumber] = None,
    compatibleRuntimes: Option[Iterable[NonEmptyString]] = None,
    createdDate: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsLambdaLayerVersionDetails = {
    import AwsLambdaLayerVersionDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsLambdaLayerVersionDetails
      .builder()
      .optionallyWith(
        version.map(value =>
          AwsLambdaLayerVersionNumber.unwrap(value): java.lang.Long
        )
      )(_.version)
      .optionallyWith(
        compatibleRuntimes.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.compatibleRuntimes)
      .optionallyWith(
        createdDate.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.createdDate)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsLambdaLayerVersionDetails.ReadOnly =
    zio.aws.securityhub.model.AwsLambdaLayerVersionDetails.wrap(buildAwsValue())
}
object AwsLambdaLayerVersionDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsLambdaLayerVersionDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsLambdaLayerVersionDetails =
      zio.aws.securityhub.model.AwsLambdaLayerVersionDetails(
        version.map(value => value),
        compatibleRuntimes.map(value => value),
        createdDate.map(value => value)
      )
    def version: Option[AwsLambdaLayerVersionNumber]
    def compatibleRuntimes: Option[List[NonEmptyString]]
    def createdDate: Option[NonEmptyString]
    def getVersion: ZIO[Any, AwsError, AwsLambdaLayerVersionNumber] =
      AwsError.unwrapOptionField("version", version)
    def getCompatibleRuntimes: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("compatibleRuntimes", compatibleRuntimes)
    def getCreatedDate: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("createdDate", createdDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsLambdaLayerVersionDetails
  ) extends zio.aws.securityhub.model.AwsLambdaLayerVersionDetails.ReadOnly {
    override val version: Option[AwsLambdaLayerVersionNumber] = scala
      .Option(impl.version())
      .map(value =>
        zio.aws.securityhub.model.primitives.AwsLambdaLayerVersionNumber(value)
      )
    override val compatibleRuntimes: Option[List[NonEmptyString]] = scala
      .Option(impl.compatibleRuntimes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.primitives.NonEmptyString(item)
        }.toList
      )
    override val createdDate: Option[NonEmptyString] = scala
      .Option(impl.createdDate())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsLambdaLayerVersionDetails
  ): zio.aws.securityhub.model.AwsLambdaLayerVersionDetails.ReadOnly =
    new Wrapper(impl)
}
