package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsIamAccessKeyDetails(
    userName: Option[NonEmptyString] = None,
    status: Option[zio.aws.securityhub.model.AwsIamAccessKeyStatus] = None,
    createdAt: Option[NonEmptyString] = None,
    principalId: Option[NonEmptyString] = None,
    principalType: Option[NonEmptyString] = None,
    principalName: Option[NonEmptyString] = None,
    accountId: Option[NonEmptyString] = None,
    accessKeyId: Option[NonEmptyString] = None,
    sessionContext: Option[
      zio.aws.securityhub.model.AwsIamAccessKeySessionContext
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsIamAccessKeyDetails = {
    import AwsIamAccessKeyDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsIamAccessKeyDetails
      .builder()
      .optionallyWith(
        userName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.userName)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        createdAt.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.createdAt)
      .optionallyWith(
        principalId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.principalId)
      .optionallyWith(
        principalType.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.principalType)
      .optionallyWith(
        principalName.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.principalName)
      .optionallyWith(
        accountId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.accountId)
      .optionallyWith(
        accessKeyId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.accessKeyId)
      .optionallyWith(sessionContext.map(value => value.buildAwsValue()))(
        _.sessionContext
      )
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.AwsIamAccessKeyDetails.ReadOnly =
    zio.aws.securityhub.model.AwsIamAccessKeyDetails.wrap(buildAwsValue())
}
object AwsIamAccessKeyDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsIamAccessKeyDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsIamAccessKeyDetails =
      zio.aws.securityhub.model.AwsIamAccessKeyDetails(
        userName.map(value => value),
        status.map(value => value),
        createdAt.map(value => value),
        principalId.map(value => value),
        principalType.map(value => value),
        principalName.map(value => value),
        accountId.map(value => value),
        accessKeyId.map(value => value),
        sessionContext.map(value => value.asEditable)
      )
    def userName: Option[NonEmptyString]
    def status: Option[zio.aws.securityhub.model.AwsIamAccessKeyStatus]
    def createdAt: Option[NonEmptyString]
    def principalId: Option[NonEmptyString]
    def principalType: Option[NonEmptyString]
    def principalName: Option[NonEmptyString]
    def accountId: Option[NonEmptyString]
    def accessKeyId: Option[NonEmptyString]
    def sessionContext: Option[
      zio.aws.securityhub.model.AwsIamAccessKeySessionContext.ReadOnly
    ]
    def getUserName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("userName", userName)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.securityhub.model.AwsIamAccessKeyStatus] =
      AwsError.unwrapOptionField("status", status)
    def getCreatedAt: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getPrincipalId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("principalId", principalId)
    def getPrincipalType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("principalType", principalType)
    def getPrincipalName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("principalName", principalName)
    def getAccountId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getAccessKeyId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("accessKeyId", accessKeyId)
    def getSessionContext: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsIamAccessKeySessionContext.ReadOnly
    ] = AwsError.unwrapOptionField("sessionContext", sessionContext)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsIamAccessKeyDetails
  ) extends zio.aws.securityhub.model.AwsIamAccessKeyDetails.ReadOnly {
    override val userName: Option[NonEmptyString] = scala
      .Option(impl.userName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val status
        : Option[zio.aws.securityhub.model.AwsIamAccessKeyStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.securityhub.model.AwsIamAccessKeyStatus.wrap(value))
    override val createdAt: Option[NonEmptyString] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val principalId: Option[NonEmptyString] = scala
      .Option(impl.principalId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val principalType: Option[NonEmptyString] = scala
      .Option(impl.principalType())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val principalName: Option[NonEmptyString] = scala
      .Option(impl.principalName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val accountId: Option[NonEmptyString] = scala
      .Option(impl.accountId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val accessKeyId: Option[NonEmptyString] = scala
      .Option(impl.accessKeyId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val sessionContext: Option[
      zio.aws.securityhub.model.AwsIamAccessKeySessionContext.ReadOnly
    ] = scala
      .Option(impl.sessionContext())
      .map(value =>
        zio.aws.securityhub.model.AwsIamAccessKeySessionContext.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsIamAccessKeyDetails
  ): zio.aws.securityhub.model.AwsIamAccessKeyDetails.ReadOnly = new Wrapper(
    impl
  )
}
