package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsElbLoadBalancerSourceSecurityGroup(
    groupName: Option[NonEmptyString] = None,
    ownerAlias: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsElbLoadBalancerSourceSecurityGroup = {
    import AwsElbLoadBalancerSourceSecurityGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsElbLoadBalancerSourceSecurityGroup
      .builder()
      .optionallyWith(
        groupName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.groupName)
      .optionallyWith(
        ownerAlias.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.ownerAlias)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsElbLoadBalancerSourceSecurityGroup.ReadOnly =
    zio.aws.securityhub.model.AwsElbLoadBalancerSourceSecurityGroup
      .wrap(buildAwsValue())
}
object AwsElbLoadBalancerSourceSecurityGroup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsElbLoadBalancerSourceSecurityGroup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsElbLoadBalancerSourceSecurityGroup =
      zio.aws.securityhub.model.AwsElbLoadBalancerSourceSecurityGroup(
        groupName.map(value => value),
        ownerAlias.map(value => value)
      )
    def groupName: Option[NonEmptyString]
    def ownerAlias: Option[NonEmptyString]
    def getGroupName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("groupName", groupName)
    def getOwnerAlias: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("ownerAlias", ownerAlias)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsElbLoadBalancerSourceSecurityGroup
  ) extends zio.aws.securityhub.model.AwsElbLoadBalancerSourceSecurityGroup.ReadOnly {
    override val groupName: Option[NonEmptyString] = scala
      .Option(impl.groupName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val ownerAlias: Option[NonEmptyString] = scala
      .Option(impl.ownerAlias())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsElbLoadBalancerSourceSecurityGroup
  ): zio.aws.securityhub.model.AwsElbLoadBalancerSourceSecurityGroup.ReadOnly =
    new Wrapper(impl)
}
