package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsElbLoadBalancerInstance(
    instanceId: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsElbLoadBalancerInstance = {
    import AwsElbLoadBalancerInstance.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsElbLoadBalancerInstance
      .builder()
      .optionallyWith(
        instanceId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.instanceId)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsElbLoadBalancerInstance.ReadOnly =
    zio.aws.securityhub.model.AwsElbLoadBalancerInstance.wrap(buildAwsValue())
}
object AwsElbLoadBalancerInstance {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsElbLoadBalancerInstance
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsElbLoadBalancerInstance =
      zio.aws.securityhub.model
        .AwsElbLoadBalancerInstance(instanceId.map(value => value))
    def instanceId: Option[NonEmptyString]
    def getInstanceId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("instanceId", instanceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsElbLoadBalancerInstance
  ) extends zio.aws.securityhub.model.AwsElbLoadBalancerInstance.ReadOnly {
    override val instanceId: Option[NonEmptyString] = scala
      .Option(impl.instanceId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsElbLoadBalancerInstance
  ): zio.aws.securityhub.model.AwsElbLoadBalancerInstance.ReadOnly =
    new Wrapper(impl)
}
