package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.Integer
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsElbLoadBalancerConnectionDraining(
    enabled: Option[Boolean] = None,
    timeout: Option[Integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsElbLoadBalancerConnectionDraining = {
    import AwsElbLoadBalancerConnectionDraining.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsElbLoadBalancerConnectionDraining
      .builder()
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .optionallyWith(
        timeout.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.timeout)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsElbLoadBalancerConnectionDraining.ReadOnly =
    zio.aws.securityhub.model.AwsElbLoadBalancerConnectionDraining
      .wrap(buildAwsValue())
}
object AwsElbLoadBalancerConnectionDraining {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsElbLoadBalancerConnectionDraining
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsElbLoadBalancerConnectionDraining =
      zio.aws.securityhub.model.AwsElbLoadBalancerConnectionDraining(
        enabled.map(value => value),
        timeout.map(value => value)
      )
    def enabled: Option[Boolean]
    def timeout: Option[Integer]
    def getEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
    def getTimeout: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("timeout", timeout)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsElbLoadBalancerConnectionDraining
  ) extends zio.aws.securityhub.model.AwsElbLoadBalancerConnectionDraining.ReadOnly {
    override val enabled: Option[Boolean] =
      scala.Option(impl.enabled()).map(value => value: Boolean)
    override val timeout: Option[Integer] = scala
      .Option(impl.timeout())
      .map(value => zio.aws.securityhub.model.primitives.Integer(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsElbLoadBalancerConnectionDraining
  ): zio.aws.securityhub.model.AwsElbLoadBalancerConnectionDraining.ReadOnly =
    new Wrapper(impl)
}
