package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsElasticBeanstalkEnvironmentTier(
    name: Option[NonEmptyString] = None,
    `type`: Option[NonEmptyString] = None,
    version: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsElasticBeanstalkEnvironmentTier = {
    import AwsElasticBeanstalkEnvironmentTier.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsElasticBeanstalkEnvironmentTier
      .builder()
      .optionallyWith(
        name.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        `type`.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.`type`)
      .optionallyWith(
        version.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.version)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsElasticBeanstalkEnvironmentTier.ReadOnly =
    zio.aws.securityhub.model.AwsElasticBeanstalkEnvironmentTier
      .wrap(buildAwsValue())
}
object AwsElasticBeanstalkEnvironmentTier {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsElasticBeanstalkEnvironmentTier
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsElasticBeanstalkEnvironmentTier =
      zio.aws.securityhub.model.AwsElasticBeanstalkEnvironmentTier(
        name.map(value => value),
        `type`.map(value => value),
        version.map(value => value)
      )
    def name: Option[NonEmptyString]
    def `type`: Option[NonEmptyString]
    def version: Option[NonEmptyString]
    def getName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("name", name)
    def getType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("type", `type`)
    def getVersion: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("version", version)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsElasticBeanstalkEnvironmentTier
  ) extends zio.aws.securityhub.model.AwsElasticBeanstalkEnvironmentTier.ReadOnly {
    override val name: Option[NonEmptyString] = scala
      .Option(impl.name())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val `type`: Option[NonEmptyString] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val version: Option[NonEmptyString] = scala
      .Option(impl.version())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsElasticBeanstalkEnvironmentTier
  ): zio.aws.securityhub.model.AwsElasticBeanstalkEnvironmentTier.ReadOnly =
    new Wrapper(impl)
}
