package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsEksClusterResourcesVpcConfigDetails(
    securityGroupIds: Option[Iterable[NonEmptyString]] = None,
    subnetIds: Option[Iterable[NonEmptyString]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEksClusterResourcesVpcConfigDetails = {
    import AwsEksClusterResourcesVpcConfigDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEksClusterResourcesVpcConfigDetails
      .builder()
      .optionallyWith(
        securityGroupIds.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroupIds)
      .optionallyWith(
        subnetIds.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.subnetIds)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEksClusterResourcesVpcConfigDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEksClusterResourcesVpcConfigDetails
      .wrap(buildAwsValue())
}
object AwsEksClusterResourcesVpcConfigDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEksClusterResourcesVpcConfigDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsEksClusterResourcesVpcConfigDetails =
      zio.aws.securityhub.model.AwsEksClusterResourcesVpcConfigDetails(
        securityGroupIds.map(value => value),
        subnetIds.map(value => value)
      )
    def securityGroupIds: Option[List[NonEmptyString]]
    def subnetIds: Option[List[NonEmptyString]]
    def getSecurityGroupIds: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("securityGroupIds", securityGroupIds)
    def getSubnetIds: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("subnetIds", subnetIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEksClusterResourcesVpcConfigDetails
  ) extends zio.aws.securityhub.model.AwsEksClusterResourcesVpcConfigDetails.ReadOnly {
    override val securityGroupIds: Option[List[NonEmptyString]] = scala
      .Option(impl.securityGroupIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.primitives.NonEmptyString(item)
        }.toList
      )
    override val subnetIds: Option[List[NonEmptyString]] = scala
      .Option(impl.subnetIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.primitives.NonEmptyString(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEksClusterResourcesVpcConfigDetails
  ): zio.aws.securityhub.model.AwsEksClusterResourcesVpcConfigDetails.ReadOnly =
    new Wrapper(impl)
}
