package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsEksClusterLoggingClusterLoggingDetails(
    enabled: Option[Boolean] = None,
    types: Option[Iterable[NonEmptyString]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEksClusterLoggingClusterLoggingDetails = {
    import AwsEksClusterLoggingClusterLoggingDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEksClusterLoggingClusterLoggingDetails
      .builder()
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .optionallyWith(
        types.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.types)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEksClusterLoggingClusterLoggingDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEksClusterLoggingClusterLoggingDetails
      .wrap(buildAwsValue())
}
object AwsEksClusterLoggingClusterLoggingDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEksClusterLoggingClusterLoggingDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsEksClusterLoggingClusterLoggingDetails =
      zio.aws.securityhub.model.AwsEksClusterLoggingClusterLoggingDetails(
        enabled.map(value => value),
        types.map(value => value)
      )
    def enabled: Option[Boolean]
    def types: Option[List[NonEmptyString]]
    def getEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
    def getTypes: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("types", types)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEksClusterLoggingClusterLoggingDetails
  ) extends zio.aws.securityhub.model.AwsEksClusterLoggingClusterLoggingDetails.ReadOnly {
    override val enabled: Option[Boolean] =
      scala.Option(impl.enabled()).map(value => value: Boolean)
    override val types: Option[List[NonEmptyString]] = scala
      .Option(impl.types())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.primitives.NonEmptyString(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEksClusterLoggingClusterLoggingDetails
  ): zio.aws.securityhub.model.AwsEksClusterLoggingClusterLoggingDetails.ReadOnly =
    new Wrapper(impl)
}
