package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{Integer, NonEmptyString}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails(
    authorizationConfig: Option[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationAuthorizationConfigDetails
    ] = None,
    filesystemId: Option[NonEmptyString] = None,
    rootDirectory: Option[NonEmptyString] = None,
    transitEncryption: Option[NonEmptyString] = None,
    transitEncryptionPort: Option[Integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails = {
    import AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails
      .builder()
      .optionallyWith(authorizationConfig.map(value => value.buildAwsValue()))(
        _.authorizationConfig
      )
      .optionallyWith(
        filesystemId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.filesystemId)
      .optionallyWith(
        rootDirectory.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.rootDirectory)
      .optionallyWith(
        transitEncryption.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.transitEncryption)
      .optionallyWith(
        transitEncryptionPort.map(value =>
          Integer.unwrap(value): java.lang.Integer
        )
      )(_.transitEncryptionPort)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails
      .wrap(buildAwsValue())
}
object AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails =
      zio.aws.securityhub.model
        .AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails(
          authorizationConfig.map(value => value.asEditable),
          filesystemId.map(value => value),
          rootDirectory.map(value => value),
          transitEncryption.map(value => value),
          transitEncryptionPort.map(value => value)
        )
    def authorizationConfig: Option[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationAuthorizationConfigDetails.ReadOnly
    ]
    def filesystemId: Option[NonEmptyString]
    def rootDirectory: Option[NonEmptyString]
    def transitEncryption: Option[NonEmptyString]
    def transitEncryptionPort: Option[Integer]
    def getAuthorizationConfig: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationAuthorizationConfigDetails.ReadOnly
    ] = AwsError.unwrapOptionField("authorizationConfig", authorizationConfig)
    def getFilesystemId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("filesystemId", filesystemId)
    def getRootDirectory: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("rootDirectory", rootDirectory)
    def getTransitEncryption: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("transitEncryption", transitEncryption)
    def getTransitEncryptionPort: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("transitEncryptionPort", transitEncryptionPort)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails
  ) extends zio.aws.securityhub.model.AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails.ReadOnly {
    override val authorizationConfig: Option[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationAuthorizationConfigDetails.ReadOnly
    ] = scala
      .Option(impl.authorizationConfig())
      .map(value =>
        zio.aws.securityhub.model.AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationAuthorizationConfigDetails
          .wrap(value)
      )
    override val filesystemId: Option[NonEmptyString] = scala
      .Option(impl.filesystemId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val rootDirectory: Option[NonEmptyString] = scala
      .Option(impl.rootDirectory())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val transitEncryption: Option[NonEmptyString] = scala
      .Option(impl.transitEncryption())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val transitEncryptionPort: Option[Integer] = scala
      .Option(impl.transitEncryptionPort())
      .map(value => zio.aws.securityhub.model.primitives.Integer(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails
  ): zio.aws.securityhub.model.AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails.ReadOnly =
    new Wrapper(impl)
}
