package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails(
    autoprovision: Option[Boolean] = None,
    driver: Option[NonEmptyString] = None,
    driverOpts: Option[Map[NonEmptyString, NonEmptyString]] = None,
    labels: Option[Map[NonEmptyString, NonEmptyString]] = None,
    scope: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails = {
    import AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails
      .builder()
      .optionallyWith(autoprovision.map(value => value: java.lang.Boolean))(
        _.autoprovision
      )
      .optionallyWith(
        driver.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.driver)
      .optionallyWith(
        driverOpts.map(value =>
          value
            .map({ case (key, value) =>
              (NonEmptyString.unwrap(key): java.lang.String) -> (NonEmptyString
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.driverOpts)
      .optionallyWith(
        labels.map(value =>
          value
            .map({ case (key, value) =>
              (NonEmptyString.unwrap(key): java.lang.String) -> (NonEmptyString
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.labels)
      .optionallyWith(
        scope.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.scope)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails
      .wrap(buildAwsValue())
}
object AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails =
      zio.aws.securityhub.model
        .AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails(
          autoprovision.map(value => value),
          driver.map(value => value),
          driverOpts.map(value => value),
          labels.map(value => value),
          scope.map(value => value)
        )
    def autoprovision: Option[Boolean]
    def driver: Option[NonEmptyString]
    def driverOpts: Option[Map[NonEmptyString, NonEmptyString]]
    def labels: Option[Map[NonEmptyString, NonEmptyString]]
    def scope: Option[NonEmptyString]
    def getAutoprovision: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("autoprovision", autoprovision)
    def getDriver: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("driver", driver)
    def getDriverOpts: ZIO[Any, AwsError, Map[NonEmptyString, NonEmptyString]] =
      AwsError.unwrapOptionField("driverOpts", driverOpts)
    def getLabels: ZIO[Any, AwsError, Map[NonEmptyString, NonEmptyString]] =
      AwsError.unwrapOptionField("labels", labels)
    def getScope: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("scope", scope)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails
  ) extends zio.aws.securityhub.model.AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails.ReadOnly {
    override val autoprovision: Option[Boolean] =
      scala.Option(impl.autoprovision()).map(value => value: Boolean)
    override val driver: Option[NonEmptyString] = scala
      .Option(impl.driver())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val driverOpts: Option[Map[NonEmptyString, NonEmptyString]] = scala
      .Option(impl.driverOpts())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.securityhub.model.primitives.NonEmptyString(
              key
            ) -> zio.aws.securityhub.model.primitives.NonEmptyString(value)
          })
          .toMap
      )
    override val labels: Option[Map[NonEmptyString, NonEmptyString]] = scala
      .Option(impl.labels())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.securityhub.model.primitives.NonEmptyString(
              key
            ) -> zio.aws.securityhub.model.primitives.NonEmptyString(value)
          })
          .toMap
      )
    override val scope: Option[NonEmptyString] = scala
      .Option(impl.scope())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails
  ): zio.aws.securityhub.model.AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails.ReadOnly =
    new Wrapper(impl)
}
