package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsEcsTaskDefinitionDetails(
    containerDefinitions: Option[Iterable[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsDetails
    ]] = None,
    cpu: Option[NonEmptyString] = None,
    executionRoleArn: Option[NonEmptyString] = None,
    family: Option[NonEmptyString] = None,
    inferenceAccelerators: Option[Iterable[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionInferenceAcceleratorsDetails
    ]] = None,
    ipcMode: Option[NonEmptyString] = None,
    memory: Option[NonEmptyString] = None,
    networkMode: Option[NonEmptyString] = None,
    pidMode: Option[NonEmptyString] = None,
    placementConstraints: Option[Iterable[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionPlacementConstraintsDetails
    ]] = None,
    proxyConfiguration: Option[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionProxyConfigurationDetails
    ] = None,
    requiresCompatibilities: Option[Iterable[NonEmptyString]] = None,
    taskRoleArn: Option[NonEmptyString] = None,
    volumes: Option[
      Iterable[zio.aws.securityhub.model.AwsEcsTaskDefinitionVolumesDetails]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionDetails = {
    import AwsEcsTaskDefinitionDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionDetails
      .builder()
      .optionallyWith(
        containerDefinitions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.containerDefinitions)
      .optionallyWith(
        cpu.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.cpu)
      .optionallyWith(
        executionRoleArn.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.executionRoleArn)
      .optionallyWith(
        family.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.family)
      .optionallyWith(
        inferenceAccelerators.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.inferenceAccelerators)
      .optionallyWith(
        ipcMode.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.ipcMode)
      .optionallyWith(
        memory.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.memory)
      .optionallyWith(
        networkMode.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.networkMode)
      .optionallyWith(
        pidMode.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.pidMode)
      .optionallyWith(
        placementConstraints.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.placementConstraints)
      .optionallyWith(proxyConfiguration.map(value => value.buildAwsValue()))(
        _.proxyConfiguration
      )
      .optionallyWith(
        requiresCompatibilities.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.requiresCompatibilities)
      .optionallyWith(
        taskRoleArn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.taskRoleArn)
      .optionallyWith(
        volumes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.volumes)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEcsTaskDefinitionDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEcsTaskDefinitionDetails.wrap(buildAwsValue())
}
object AwsEcsTaskDefinitionDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsEcsTaskDefinitionDetails =
      zio.aws.securityhub.model.AwsEcsTaskDefinitionDetails(
        containerDefinitions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        cpu.map(value => value),
        executionRoleArn.map(value => value),
        family.map(value => value),
        inferenceAccelerators.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ipcMode.map(value => value),
        memory.map(value => value),
        networkMode.map(value => value),
        pidMode.map(value => value),
        placementConstraints.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        proxyConfiguration.map(value => value.asEditable),
        requiresCompatibilities.map(value => value),
        taskRoleArn.map(value => value),
        volumes.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def containerDefinitions: Option[List[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsDetails.ReadOnly
    ]]
    def cpu: Option[NonEmptyString]
    def executionRoleArn: Option[NonEmptyString]
    def family: Option[NonEmptyString]
    def inferenceAccelerators: Option[List[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionInferenceAcceleratorsDetails.ReadOnly
    ]]
    def ipcMode: Option[NonEmptyString]
    def memory: Option[NonEmptyString]
    def networkMode: Option[NonEmptyString]
    def pidMode: Option[NonEmptyString]
    def placementConstraints: Option[List[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionPlacementConstraintsDetails.ReadOnly
    ]]
    def proxyConfiguration: Option[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionProxyConfigurationDetails.ReadOnly
    ]
    def requiresCompatibilities: Option[List[NonEmptyString]]
    def taskRoleArn: Option[NonEmptyString]
    def volumes: Option[List[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionVolumesDetails.ReadOnly
    ]]
    def getContainerDefinitions: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsDetails.ReadOnly
    ]] =
      AwsError.unwrapOptionField("containerDefinitions", containerDefinitions)
    def getCpu: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("cpu", cpu)
    def getExecutionRoleArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("executionRoleArn", executionRoleArn)
    def getFamily: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("family", family)
    def getInferenceAccelerators: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionInferenceAcceleratorsDetails.ReadOnly
    ]] =
      AwsError.unwrapOptionField("inferenceAccelerators", inferenceAccelerators)
    def getIpcMode: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("ipcMode", ipcMode)
    def getMemory: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("memory", memory)
    def getNetworkMode: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("networkMode", networkMode)
    def getPidMode: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("pidMode", pidMode)
    def getPlacementConstraints: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionPlacementConstraintsDetails.ReadOnly
    ]] =
      AwsError.unwrapOptionField("placementConstraints", placementConstraints)
    def getProxyConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsEcsTaskDefinitionProxyConfigurationDetails.ReadOnly
    ] = AwsError.unwrapOptionField("proxyConfiguration", proxyConfiguration)
    def getRequiresCompatibilities: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField(
        "requiresCompatibilities",
        requiresCompatibilities
      )
    def getTaskRoleArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("taskRoleArn", taskRoleArn)
    def getVolumes: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionVolumesDetails.ReadOnly
    ]] = AwsError.unwrapOptionField("volumes", volumes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionDetails
  ) extends zio.aws.securityhub.model.AwsEcsTaskDefinitionDetails.ReadOnly {
    override val containerDefinitions: Option[List[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsDetails.ReadOnly
    ]] = scala
      .Option(impl.containerDefinitions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsDetails
            .wrap(item)
        }.toList
      )
    override val cpu: Option[NonEmptyString] = scala
      .Option(impl.cpu())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val executionRoleArn: Option[NonEmptyString] = scala
      .Option(impl.executionRoleArn())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val family: Option[NonEmptyString] = scala
      .Option(impl.family())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val inferenceAccelerators: Option[List[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionInferenceAcceleratorsDetails.ReadOnly
    ]] = scala
      .Option(impl.inferenceAccelerators())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsEcsTaskDefinitionInferenceAcceleratorsDetails
            .wrap(item)
        }.toList
      )
    override val ipcMode: Option[NonEmptyString] = scala
      .Option(impl.ipcMode())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val memory: Option[NonEmptyString] = scala
      .Option(impl.memory())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val networkMode: Option[NonEmptyString] = scala
      .Option(impl.networkMode())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val pidMode: Option[NonEmptyString] = scala
      .Option(impl.pidMode())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val placementConstraints: Option[List[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionPlacementConstraintsDetails.ReadOnly
    ]] = scala
      .Option(impl.placementConstraints())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsEcsTaskDefinitionPlacementConstraintsDetails
            .wrap(item)
        }.toList
      )
    override val proxyConfiguration: Option[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionProxyConfigurationDetails.ReadOnly
    ] = scala
      .Option(impl.proxyConfiguration())
      .map(value =>
        zio.aws.securityhub.model.AwsEcsTaskDefinitionProxyConfigurationDetails
          .wrap(value)
      )
    override val requiresCompatibilities: Option[List[NonEmptyString]] = scala
      .Option(impl.requiresCompatibilities())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.primitives.NonEmptyString(item)
        }.toList
      )
    override val taskRoleArn: Option[NonEmptyString] = scala
      .Option(impl.taskRoleArn())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val volumes: Option[List[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionVolumesDetails.ReadOnly
    ]] = scala
      .Option(impl.volumes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsEcsTaskDefinitionVolumesDetails
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionDetails
  ): zio.aws.securityhub.model.AwsEcsTaskDefinitionDetails.ReadOnly =
    new Wrapper(impl)
}
