package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsEcsTaskDefinitionContainerDefinitionsExtraHostsDetails(
    hostname: Option[NonEmptyString] = None,
    ipAddress: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsExtraHostsDetails = {
    import AwsEcsTaskDefinitionContainerDefinitionsExtraHostsDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsExtraHostsDetails
      .builder()
      .optionallyWith(
        hostname.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.hostname)
      .optionallyWith(
        ipAddress.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.ipAddress)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsExtraHostsDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsExtraHostsDetails
      .wrap(buildAwsValue())
}
object AwsEcsTaskDefinitionContainerDefinitionsExtraHostsDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsExtraHostsDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsExtraHostsDetails =
      zio.aws.securityhub.model
        .AwsEcsTaskDefinitionContainerDefinitionsExtraHostsDetails(
          hostname.map(value => value),
          ipAddress.map(value => value)
        )
    def hostname: Option[NonEmptyString]
    def ipAddress: Option[NonEmptyString]
    def getHostname: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("hostname", hostname)
    def getIpAddress: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("ipAddress", ipAddress)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsExtraHostsDetails
  ) extends zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsExtraHostsDetails.ReadOnly {
    override val hostname: Option[NonEmptyString] = scala
      .Option(impl.hostname())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val ipAddress: Option[NonEmptyString] = scala
      .Option(impl.ipAddress())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsExtraHostsDetails
  ): zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsExtraHostsDetails.ReadOnly =
    new Wrapper(impl)
}
