package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsEcrRepositoryDetails(
    arn: Option[NonEmptyString] = None,
    imageScanningConfiguration: Option[
      zio.aws.securityhub.model.AwsEcrRepositoryImageScanningConfigurationDetails
    ] = None,
    imageTagMutability: Option[NonEmptyString] = None,
    lifecyclePolicy: Option[
      zio.aws.securityhub.model.AwsEcrRepositoryLifecyclePolicyDetails
    ] = None,
    repositoryName: Option[NonEmptyString] = None,
    repositoryPolicyText: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEcrRepositoryDetails = {
    import AwsEcrRepositoryDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEcrRepositoryDetails
      .builder()
      .optionallyWith(
        arn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        imageScanningConfiguration.map(value => value.buildAwsValue())
      )(_.imageScanningConfiguration)
      .optionallyWith(
        imageTagMutability.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.imageTagMutability)
      .optionallyWith(lifecyclePolicy.map(value => value.buildAwsValue()))(
        _.lifecyclePolicy
      )
      .optionallyWith(
        repositoryName.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.repositoryName)
      .optionallyWith(
        repositoryPolicyText.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.repositoryPolicyText)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.AwsEcrRepositoryDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEcrRepositoryDetails.wrap(buildAwsValue())
}
object AwsEcrRepositoryDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEcrRepositoryDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsEcrRepositoryDetails =
      zio.aws.securityhub.model.AwsEcrRepositoryDetails(
        arn.map(value => value),
        imageScanningConfiguration.map(value => value.asEditable),
        imageTagMutability.map(value => value),
        lifecyclePolicy.map(value => value.asEditable),
        repositoryName.map(value => value),
        repositoryPolicyText.map(value => value)
      )
    def arn: Option[NonEmptyString]
    def imageScanningConfiguration: Option[
      zio.aws.securityhub.model.AwsEcrRepositoryImageScanningConfigurationDetails.ReadOnly
    ]
    def imageTagMutability: Option[NonEmptyString]
    def lifecyclePolicy: Option[
      zio.aws.securityhub.model.AwsEcrRepositoryLifecyclePolicyDetails.ReadOnly
    ]
    def repositoryName: Option[NonEmptyString]
    def repositoryPolicyText: Option[NonEmptyString]
    def getArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("arn", arn)
    def getImageScanningConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsEcrRepositoryImageScanningConfigurationDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "imageScanningConfiguration",
      imageScanningConfiguration
    )
    def getImageTagMutability: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("imageTagMutability", imageTagMutability)
    def getLifecyclePolicy: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsEcrRepositoryLifecyclePolicyDetails.ReadOnly
    ] = AwsError.unwrapOptionField("lifecyclePolicy", lifecyclePolicy)
    def getRepositoryName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("repositoryName", repositoryName)
    def getRepositoryPolicyText: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("repositoryPolicyText", repositoryPolicyText)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEcrRepositoryDetails
  ) extends zio.aws.securityhub.model.AwsEcrRepositoryDetails.ReadOnly {
    override val arn: Option[NonEmptyString] = scala
      .Option(impl.arn())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val imageScanningConfiguration: Option[
      zio.aws.securityhub.model.AwsEcrRepositoryImageScanningConfigurationDetails.ReadOnly
    ] = scala
      .Option(impl.imageScanningConfiguration())
      .map(value =>
        zio.aws.securityhub.model.AwsEcrRepositoryImageScanningConfigurationDetails
          .wrap(value)
      )
    override val imageTagMutability: Option[NonEmptyString] = scala
      .Option(impl.imageTagMutability())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val lifecyclePolicy: Option[
      zio.aws.securityhub.model.AwsEcrRepositoryLifecyclePolicyDetails.ReadOnly
    ] = scala
      .Option(impl.lifecyclePolicy())
      .map(value =>
        zio.aws.securityhub.model.AwsEcrRepositoryLifecyclePolicyDetails
          .wrap(value)
      )
    override val repositoryName: Option[NonEmptyString] = scala
      .Option(impl.repositoryName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val repositoryPolicyText: Option[NonEmptyString] = scala
      .Option(impl.repositoryPolicyText())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEcrRepositoryDetails
  ): zio.aws.securityhub.model.AwsEcrRepositoryDetails.ReadOnly = new Wrapper(
    impl
  )
}
