package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{SizeBytes, Integer, NonEmptyString}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsDynamoDbTableDetails(
    attributeDefinitions: Option[
      Iterable[zio.aws.securityhub.model.AwsDynamoDbTableAttributeDefinition]
    ] = None,
    billingModeSummary: Option[
      zio.aws.securityhub.model.AwsDynamoDbTableBillingModeSummary
    ] = None,
    creationDateTime: Option[NonEmptyString] = None,
    globalSecondaryIndexes: Option[
      Iterable[zio.aws.securityhub.model.AwsDynamoDbTableGlobalSecondaryIndex]
    ] = None,
    globalTableVersion: Option[NonEmptyString] = None,
    itemCount: Option[Integer] = None,
    keySchema: Option[
      Iterable[zio.aws.securityhub.model.AwsDynamoDbTableKeySchema]
    ] = None,
    latestStreamArn: Option[NonEmptyString] = None,
    latestStreamLabel: Option[NonEmptyString] = None,
    localSecondaryIndexes: Option[
      Iterable[zio.aws.securityhub.model.AwsDynamoDbTableLocalSecondaryIndex]
    ] = None,
    provisionedThroughput: Option[
      zio.aws.securityhub.model.AwsDynamoDbTableProvisionedThroughput
    ] = None,
    replicas: Option[
      Iterable[zio.aws.securityhub.model.AwsDynamoDbTableReplica]
    ] = None,
    restoreSummary: Option[
      zio.aws.securityhub.model.AwsDynamoDbTableRestoreSummary
    ] = None,
    sseDescription: Option[
      zio.aws.securityhub.model.AwsDynamoDbTableSseDescription
    ] = None,
    streamSpecification: Option[
      zio.aws.securityhub.model.AwsDynamoDbTableStreamSpecification
    ] = None,
    tableId: Option[NonEmptyString] = None,
    tableName: Option[NonEmptyString] = None,
    tableSizeBytes: Option[SizeBytes] = None,
    tableStatus: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsDynamoDbTableDetails = {
    import AwsDynamoDbTableDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsDynamoDbTableDetails
      .builder()
      .optionallyWith(
        attributeDefinitions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.attributeDefinitions)
      .optionallyWith(billingModeSummary.map(value => value.buildAwsValue()))(
        _.billingModeSummary
      )
      .optionallyWith(
        creationDateTime.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.creationDateTime)
      .optionallyWith(
        globalSecondaryIndexes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.globalSecondaryIndexes)
      .optionallyWith(
        globalTableVersion.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.globalTableVersion)
      .optionallyWith(
        itemCount.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.itemCount)
      .optionallyWith(
        keySchema.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.keySchema)
      .optionallyWith(
        latestStreamArn.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.latestStreamArn)
      .optionallyWith(
        latestStreamLabel.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.latestStreamLabel)
      .optionallyWith(
        localSecondaryIndexes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.localSecondaryIndexes)
      .optionallyWith(
        provisionedThroughput.map(value => value.buildAwsValue())
      )(_.provisionedThroughput)
      .optionallyWith(
        replicas.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.replicas)
      .optionallyWith(restoreSummary.map(value => value.buildAwsValue()))(
        _.restoreSummary
      )
      .optionallyWith(sseDescription.map(value => value.buildAwsValue()))(
        _.sseDescription
      )
      .optionallyWith(streamSpecification.map(value => value.buildAwsValue()))(
        _.streamSpecification
      )
      .optionallyWith(
        tableId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.tableId)
      .optionallyWith(
        tableName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.tableName)
      .optionallyWith(
        tableSizeBytes.map(value => SizeBytes.unwrap(value): java.lang.Long)
      )(_.tableSizeBytes)
      .optionallyWith(
        tableStatus.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.tableStatus)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.AwsDynamoDbTableDetails.ReadOnly =
    zio.aws.securityhub.model.AwsDynamoDbTableDetails.wrap(buildAwsValue())
}
object AwsDynamoDbTableDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsDynamoDbTableDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsDynamoDbTableDetails =
      zio.aws.securityhub.model.AwsDynamoDbTableDetails(
        attributeDefinitions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        billingModeSummary.map(value => value.asEditable),
        creationDateTime.map(value => value),
        globalSecondaryIndexes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        globalTableVersion.map(value => value),
        itemCount.map(value => value),
        keySchema.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        latestStreamArn.map(value => value),
        latestStreamLabel.map(value => value),
        localSecondaryIndexes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        provisionedThroughput.map(value => value.asEditable),
        replicas.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        restoreSummary.map(value => value.asEditable),
        sseDescription.map(value => value.asEditable),
        streamSpecification.map(value => value.asEditable),
        tableId.map(value => value),
        tableName.map(value => value),
        tableSizeBytes.map(value => value),
        tableStatus.map(value => value)
      )
    def attributeDefinitions: Option[List[
      zio.aws.securityhub.model.AwsDynamoDbTableAttributeDefinition.ReadOnly
    ]]
    def billingModeSummary: Option[
      zio.aws.securityhub.model.AwsDynamoDbTableBillingModeSummary.ReadOnly
    ]
    def creationDateTime: Option[NonEmptyString]
    def globalSecondaryIndexes: Option[List[
      zio.aws.securityhub.model.AwsDynamoDbTableGlobalSecondaryIndex.ReadOnly
    ]]
    def globalTableVersion: Option[NonEmptyString]
    def itemCount: Option[Integer]
    def keySchema: Option[
      List[zio.aws.securityhub.model.AwsDynamoDbTableKeySchema.ReadOnly]
    ]
    def latestStreamArn: Option[NonEmptyString]
    def latestStreamLabel: Option[NonEmptyString]
    def localSecondaryIndexes: Option[List[
      zio.aws.securityhub.model.AwsDynamoDbTableLocalSecondaryIndex.ReadOnly
    ]]
    def provisionedThroughput: Option[
      zio.aws.securityhub.model.AwsDynamoDbTableProvisionedThroughput.ReadOnly
    ]
    def replicas: Option[
      List[zio.aws.securityhub.model.AwsDynamoDbTableReplica.ReadOnly]
    ]
    def restoreSummary: Option[
      zio.aws.securityhub.model.AwsDynamoDbTableRestoreSummary.ReadOnly
    ]
    def sseDescription: Option[
      zio.aws.securityhub.model.AwsDynamoDbTableSseDescription.ReadOnly
    ]
    def streamSpecification: Option[
      zio.aws.securityhub.model.AwsDynamoDbTableStreamSpecification.ReadOnly
    ]
    def tableId: Option[NonEmptyString]
    def tableName: Option[NonEmptyString]
    def tableSizeBytes: Option[SizeBytes]
    def tableStatus: Option[NonEmptyString]
    def getAttributeDefinitions: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsDynamoDbTableAttributeDefinition.ReadOnly
    ]] =
      AwsError.unwrapOptionField("attributeDefinitions", attributeDefinitions)
    def getBillingModeSummary: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsDynamoDbTableBillingModeSummary.ReadOnly
    ] = AwsError.unwrapOptionField("billingModeSummary", billingModeSummary)
    def getCreationDateTime: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("creationDateTime", creationDateTime)
    def getGlobalSecondaryIndexes: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsDynamoDbTableGlobalSecondaryIndex.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "globalSecondaryIndexes",
      globalSecondaryIndexes
    )
    def getGlobalTableVersion: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("globalTableVersion", globalTableVersion)
    def getItemCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("itemCount", itemCount)
    def getKeySchema: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsDynamoDbTableKeySchema.ReadOnly
    ]] = AwsError.unwrapOptionField("keySchema", keySchema)
    def getLatestStreamArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("latestStreamArn", latestStreamArn)
    def getLatestStreamLabel: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("latestStreamLabel", latestStreamLabel)
    def getLocalSecondaryIndexes: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsDynamoDbTableLocalSecondaryIndex.ReadOnly
    ]] =
      AwsError.unwrapOptionField("localSecondaryIndexes", localSecondaryIndexes)
    def getProvisionedThroughput: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsDynamoDbTableProvisionedThroughput.ReadOnly
    ] =
      AwsError.unwrapOptionField("provisionedThroughput", provisionedThroughput)
    def getReplicas: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsDynamoDbTableReplica.ReadOnly
    ]] = AwsError.unwrapOptionField("replicas", replicas)
    def getRestoreSummary: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsDynamoDbTableRestoreSummary.ReadOnly
    ] = AwsError.unwrapOptionField("restoreSummary", restoreSummary)
    def getSseDescription: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsDynamoDbTableSseDescription.ReadOnly
    ] = AwsError.unwrapOptionField("sseDescription", sseDescription)
    def getStreamSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsDynamoDbTableStreamSpecification.ReadOnly
    ] = AwsError.unwrapOptionField("streamSpecification", streamSpecification)
    def getTableId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("tableId", tableId)
    def getTableName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("tableName", tableName)
    def getTableSizeBytes: ZIO[Any, AwsError, SizeBytes] =
      AwsError.unwrapOptionField("tableSizeBytes", tableSizeBytes)
    def getTableStatus: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("tableStatus", tableStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsDynamoDbTableDetails
  ) extends zio.aws.securityhub.model.AwsDynamoDbTableDetails.ReadOnly {
    override val attributeDefinitions: Option[List[
      zio.aws.securityhub.model.AwsDynamoDbTableAttributeDefinition.ReadOnly
    ]] = scala
      .Option(impl.attributeDefinitions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsDynamoDbTableAttributeDefinition
            .wrap(item)
        }.toList
      )
    override val billingModeSummary: Option[
      zio.aws.securityhub.model.AwsDynamoDbTableBillingModeSummary.ReadOnly
    ] = scala
      .Option(impl.billingModeSummary())
      .map(value =>
        zio.aws.securityhub.model.AwsDynamoDbTableBillingModeSummary.wrap(value)
      )
    override val creationDateTime: Option[NonEmptyString] = scala
      .Option(impl.creationDateTime())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val globalSecondaryIndexes: Option[List[
      zio.aws.securityhub.model.AwsDynamoDbTableGlobalSecondaryIndex.ReadOnly
    ]] = scala
      .Option(impl.globalSecondaryIndexes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsDynamoDbTableGlobalSecondaryIndex
            .wrap(item)
        }.toList
      )
    override val globalTableVersion: Option[NonEmptyString] = scala
      .Option(impl.globalTableVersion())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val itemCount: Option[Integer] = scala
      .Option(impl.itemCount())
      .map(value => zio.aws.securityhub.model.primitives.Integer(value))
    override val keySchema: Option[
      List[zio.aws.securityhub.model.AwsDynamoDbTableKeySchema.ReadOnly]
    ] = scala
      .Option(impl.keySchema())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsDynamoDbTableKeySchema.wrap(item)
        }.toList
      )
    override val latestStreamArn: Option[NonEmptyString] = scala
      .Option(impl.latestStreamArn())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val latestStreamLabel: Option[NonEmptyString] = scala
      .Option(impl.latestStreamLabel())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val localSecondaryIndexes: Option[List[
      zio.aws.securityhub.model.AwsDynamoDbTableLocalSecondaryIndex.ReadOnly
    ]] = scala
      .Option(impl.localSecondaryIndexes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsDynamoDbTableLocalSecondaryIndex
            .wrap(item)
        }.toList
      )
    override val provisionedThroughput: Option[
      zio.aws.securityhub.model.AwsDynamoDbTableProvisionedThroughput.ReadOnly
    ] = scala
      .Option(impl.provisionedThroughput())
      .map(value =>
        zio.aws.securityhub.model.AwsDynamoDbTableProvisionedThroughput
          .wrap(value)
      )
    override val replicas: Option[
      List[zio.aws.securityhub.model.AwsDynamoDbTableReplica.ReadOnly]
    ] = scala
      .Option(impl.replicas())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsDynamoDbTableReplica.wrap(item)
        }.toList
      )
    override val restoreSummary: Option[
      zio.aws.securityhub.model.AwsDynamoDbTableRestoreSummary.ReadOnly
    ] = scala
      .Option(impl.restoreSummary())
      .map(value =>
        zio.aws.securityhub.model.AwsDynamoDbTableRestoreSummary.wrap(value)
      )
    override val sseDescription: Option[
      zio.aws.securityhub.model.AwsDynamoDbTableSseDescription.ReadOnly
    ] = scala
      .Option(impl.sseDescription())
      .map(value =>
        zio.aws.securityhub.model.AwsDynamoDbTableSseDescription.wrap(value)
      )
    override val streamSpecification: Option[
      zio.aws.securityhub.model.AwsDynamoDbTableStreamSpecification.ReadOnly
    ] = scala
      .Option(impl.streamSpecification())
      .map(value =>
        zio.aws.securityhub.model.AwsDynamoDbTableStreamSpecification
          .wrap(value)
      )
    override val tableId: Option[NonEmptyString] = scala
      .Option(impl.tableId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val tableName: Option[NonEmptyString] = scala
      .Option(impl.tableName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val tableSizeBytes: Option[SizeBytes] = scala
      .Option(impl.tableSizeBytes())
      .map(value => zio.aws.securityhub.model.primitives.SizeBytes(value))
    override val tableStatus: Option[NonEmptyString] = scala
      .Option(impl.tableStatus())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsDynamoDbTableDetails
  ): zio.aws.securityhub.model.AwsDynamoDbTableDetails.ReadOnly = new Wrapper(
    impl
  )
}
