package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsCodeBuildProjectArtifactsDetails(
    artifactIdentifier: Option[NonEmptyString] = None,
    encryptionDisabled: Option[Boolean] = None,
    location: Option[NonEmptyString] = None,
    name: Option[NonEmptyString] = None,
    namespaceType: Option[NonEmptyString] = None,
    overrideArtifactName: Option[Boolean] = None,
    packaging: Option[NonEmptyString] = None,
    path: Option[NonEmptyString] = None,
    `type`: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsCodeBuildProjectArtifactsDetails = {
    import AwsCodeBuildProjectArtifactsDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsCodeBuildProjectArtifactsDetails
      .builder()
      .optionallyWith(
        artifactIdentifier.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.artifactIdentifier)
      .optionallyWith(
        encryptionDisabled.map(value => value: java.lang.Boolean)
      )(_.encryptionDisabled)
      .optionallyWith(
        location.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.location)
      .optionallyWith(
        name.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        namespaceType.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.namespaceType)
      .optionallyWith(
        overrideArtifactName.map(value => value: java.lang.Boolean)
      )(_.overrideArtifactName)
      .optionallyWith(
        packaging.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.packaging)
      .optionallyWith(
        path.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.path)
      .optionallyWith(
        `type`.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.`type`)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsCodeBuildProjectArtifactsDetails.ReadOnly =
    zio.aws.securityhub.model.AwsCodeBuildProjectArtifactsDetails
      .wrap(buildAwsValue())
}
object AwsCodeBuildProjectArtifactsDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsCodeBuildProjectArtifactsDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsCodeBuildProjectArtifactsDetails =
      zio.aws.securityhub.model.AwsCodeBuildProjectArtifactsDetails(
        artifactIdentifier.map(value => value),
        encryptionDisabled.map(value => value),
        location.map(value => value),
        name.map(value => value),
        namespaceType.map(value => value),
        overrideArtifactName.map(value => value),
        packaging.map(value => value),
        path.map(value => value),
        `type`.map(value => value)
      )
    def artifactIdentifier: Option[NonEmptyString]
    def encryptionDisabled: Option[Boolean]
    def location: Option[NonEmptyString]
    def name: Option[NonEmptyString]
    def namespaceType: Option[NonEmptyString]
    def overrideArtifactName: Option[Boolean]
    def packaging: Option[NonEmptyString]
    def path: Option[NonEmptyString]
    def `type`: Option[NonEmptyString]
    def getArtifactIdentifier: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("artifactIdentifier", artifactIdentifier)
    def getEncryptionDisabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("encryptionDisabled", encryptionDisabled)
    def getLocation: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("location", location)
    def getName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("name", name)
    def getNamespaceType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("namespaceType", namespaceType)
    def getOverrideArtifactName: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("overrideArtifactName", overrideArtifactName)
    def getPackaging: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("packaging", packaging)
    def getPath: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("path", path)
    def getType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsCodeBuildProjectArtifactsDetails
  ) extends zio.aws.securityhub.model.AwsCodeBuildProjectArtifactsDetails.ReadOnly {
    override val artifactIdentifier: Option[NonEmptyString] = scala
      .Option(impl.artifactIdentifier())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val encryptionDisabled: Option[Boolean] =
      scala.Option(impl.encryptionDisabled()).map(value => value: Boolean)
    override val location: Option[NonEmptyString] = scala
      .Option(impl.location())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val name: Option[NonEmptyString] = scala
      .Option(impl.name())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val namespaceType: Option[NonEmptyString] = scala
      .Option(impl.namespaceType())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val overrideArtifactName: Option[Boolean] =
      scala.Option(impl.overrideArtifactName()).map(value => value: Boolean)
    override val packaging: Option[NonEmptyString] = scala
      .Option(impl.packaging())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val path: Option[NonEmptyString] = scala
      .Option(impl.path())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val `type`: Option[NonEmptyString] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsCodeBuildProjectArtifactsDetails
  ): zio.aws.securityhub.model.AwsCodeBuildProjectArtifactsDetails.ReadOnly =
    new Wrapper(impl)
}
