package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsCloudFrontDistributionOriginItem(
    domainName: Option[NonEmptyString] = None,
    id: Option[NonEmptyString] = None,
    originPath: Option[NonEmptyString] = None,
    s3OriginConfig: Option[
      zio.aws.securityhub.model.AwsCloudFrontDistributionOriginS3OriginConfig
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsCloudFrontDistributionOriginItem = {
    import AwsCloudFrontDistributionOriginItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsCloudFrontDistributionOriginItem
      .builder()
      .optionallyWith(
        domainName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.domainName)
      .optionallyWith(
        id.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        originPath.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.originPath)
      .optionallyWith(s3OriginConfig.map(value => value.buildAwsValue()))(
        _.s3OriginConfig
      )
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsCloudFrontDistributionOriginItem.ReadOnly =
    zio.aws.securityhub.model.AwsCloudFrontDistributionOriginItem
      .wrap(buildAwsValue())
}
object AwsCloudFrontDistributionOriginItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsCloudFrontDistributionOriginItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsCloudFrontDistributionOriginItem =
      zio.aws.securityhub.model.AwsCloudFrontDistributionOriginItem(
        domainName.map(value => value),
        id.map(value => value),
        originPath.map(value => value),
        s3OriginConfig.map(value => value.asEditable)
      )
    def domainName: Option[NonEmptyString]
    def id: Option[NonEmptyString]
    def originPath: Option[NonEmptyString]
    def s3OriginConfig: Option[
      zio.aws.securityhub.model.AwsCloudFrontDistributionOriginS3OriginConfig.ReadOnly
    ]
    def getDomainName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("domainName", domainName)
    def getId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("id", id)
    def getOriginPath: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("originPath", originPath)
    def getS3OriginConfig: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsCloudFrontDistributionOriginS3OriginConfig.ReadOnly
    ] = AwsError.unwrapOptionField("s3OriginConfig", s3OriginConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsCloudFrontDistributionOriginItem
  ) extends zio.aws.securityhub.model.AwsCloudFrontDistributionOriginItem.ReadOnly {
    override val domainName: Option[NonEmptyString] = scala
      .Option(impl.domainName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val id: Option[NonEmptyString] = scala
      .Option(impl.id())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val originPath: Option[NonEmptyString] = scala
      .Option(impl.originPath())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val s3OriginConfig: Option[
      zio.aws.securityhub.model.AwsCloudFrontDistributionOriginS3OriginConfig.ReadOnly
    ] = scala
      .Option(impl.s3OriginConfig())
      .map(value =>
        zio.aws.securityhub.model.AwsCloudFrontDistributionOriginS3OriginConfig
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsCloudFrontDistributionOriginItem
  ): zio.aws.securityhub.model.AwsCloudFrontDistributionOriginItem.ReadOnly =
    new Wrapper(impl)
}
