package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsCertificateManagerCertificateKeyUsage(
    name: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsCertificateManagerCertificateKeyUsage = {
    import AwsCertificateManagerCertificateKeyUsage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsCertificateManagerCertificateKeyUsage
      .builder()
      .optionallyWith(
        name.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.name)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsCertificateManagerCertificateKeyUsage.ReadOnly =
    zio.aws.securityhub.model.AwsCertificateManagerCertificateKeyUsage
      .wrap(buildAwsValue())
}
object AwsCertificateManagerCertificateKeyUsage {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsCertificateManagerCertificateKeyUsage
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsCertificateManagerCertificateKeyUsage =
      zio.aws.securityhub.model
        .AwsCertificateManagerCertificateKeyUsage(name.map(value => value))
    def name: Option[NonEmptyString]
    def getName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsCertificateManagerCertificateKeyUsage
  ) extends zio.aws.securityhub.model.AwsCertificateManagerCertificateKeyUsage.ReadOnly {
    override val name: Option[NonEmptyString] = scala
      .Option(impl.name())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsCertificateManagerCertificateKeyUsage
  ): zio.aws.securityhub.model.AwsCertificateManagerCertificateKeyUsage.ReadOnly =
    new Wrapper(impl)
}
