package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsAutoScalingLaunchConfigurationDetails(
    associatePublicIpAddress: Option[Boolean] = None,
    blockDeviceMappings: Option[Iterable[
      zio.aws.securityhub.model.AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails
    ]] = None,
    classicLinkVpcId: Option[NonEmptyString] = None,
    classicLinkVpcSecurityGroups: Option[Iterable[NonEmptyString]] = None,
    createdTime: Option[NonEmptyString] = None,
    ebsOptimized: Option[Boolean] = None,
    iamInstanceProfile: Option[NonEmptyString] = None,
    imageId: Option[NonEmptyString] = None,
    instanceMonitoring: Option[
      zio.aws.securityhub.model.AwsAutoScalingLaunchConfigurationInstanceMonitoringDetails
    ] = None,
    instanceType: Option[NonEmptyString] = None,
    kernelId: Option[NonEmptyString] = None,
    keyName: Option[NonEmptyString] = None,
    launchConfigurationName: Option[NonEmptyString] = None,
    placementTenancy: Option[NonEmptyString] = None,
    ramdiskId: Option[NonEmptyString] = None,
    securityGroups: Option[Iterable[NonEmptyString]] = None,
    spotPrice: Option[NonEmptyString] = None,
    userData: Option[NonEmptyString] = None,
    metadataOptions: Option[
      zio.aws.securityhub.model.AwsAutoScalingLaunchConfigurationMetadataOptions
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsAutoScalingLaunchConfigurationDetails = {
    import AwsAutoScalingLaunchConfigurationDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsAutoScalingLaunchConfigurationDetails
      .builder()
      .optionallyWith(
        associatePublicIpAddress.map(value => value: java.lang.Boolean)
      )(_.associatePublicIpAddress)
      .optionallyWith(
        blockDeviceMappings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.blockDeviceMappings)
      .optionallyWith(
        classicLinkVpcId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.classicLinkVpcId)
      .optionallyWith(
        classicLinkVpcSecurityGroups.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.classicLinkVpcSecurityGroups)
      .optionallyWith(
        createdTime.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.createdTime)
      .optionallyWith(ebsOptimized.map(value => value: java.lang.Boolean))(
        _.ebsOptimized
      )
      .optionallyWith(
        iamInstanceProfile.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.iamInstanceProfile)
      .optionallyWith(
        imageId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.imageId)
      .optionallyWith(instanceMonitoring.map(value => value.buildAwsValue()))(
        _.instanceMonitoring
      )
      .optionallyWith(
        instanceType.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.instanceType)
      .optionallyWith(
        kernelId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.kernelId)
      .optionallyWith(
        keyName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.keyName)
      .optionallyWith(
        launchConfigurationName.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.launchConfigurationName)
      .optionallyWith(
        placementTenancy.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.placementTenancy)
      .optionallyWith(
        ramdiskId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.ramdiskId)
      .optionallyWith(
        securityGroups.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroups)
      .optionallyWith(
        spotPrice.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.spotPrice)
      .optionallyWith(
        userData.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.userData)
      .optionallyWith(metadataOptions.map(value => value.buildAwsValue()))(
        _.metadataOptions
      )
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsAutoScalingLaunchConfigurationDetails.ReadOnly =
    zio.aws.securityhub.model.AwsAutoScalingLaunchConfigurationDetails
      .wrap(buildAwsValue())
}
object AwsAutoScalingLaunchConfigurationDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsAutoScalingLaunchConfigurationDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsAutoScalingLaunchConfigurationDetails =
      zio.aws.securityhub.model.AwsAutoScalingLaunchConfigurationDetails(
        associatePublicIpAddress.map(value => value),
        blockDeviceMappings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        classicLinkVpcId.map(value => value),
        classicLinkVpcSecurityGroups.map(value => value),
        createdTime.map(value => value),
        ebsOptimized.map(value => value),
        iamInstanceProfile.map(value => value),
        imageId.map(value => value),
        instanceMonitoring.map(value => value.asEditable),
        instanceType.map(value => value),
        kernelId.map(value => value),
        keyName.map(value => value),
        launchConfigurationName.map(value => value),
        placementTenancy.map(value => value),
        ramdiskId.map(value => value),
        securityGroups.map(value => value),
        spotPrice.map(value => value),
        userData.map(value => value),
        metadataOptions.map(value => value.asEditable)
      )
    def associatePublicIpAddress: Option[Boolean]
    def blockDeviceMappings: Option[List[
      zio.aws.securityhub.model.AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails.ReadOnly
    ]]
    def classicLinkVpcId: Option[NonEmptyString]
    def classicLinkVpcSecurityGroups: Option[List[NonEmptyString]]
    def createdTime: Option[NonEmptyString]
    def ebsOptimized: Option[Boolean]
    def iamInstanceProfile: Option[NonEmptyString]
    def imageId: Option[NonEmptyString]
    def instanceMonitoring: Option[
      zio.aws.securityhub.model.AwsAutoScalingLaunchConfigurationInstanceMonitoringDetails.ReadOnly
    ]
    def instanceType: Option[NonEmptyString]
    def kernelId: Option[NonEmptyString]
    def keyName: Option[NonEmptyString]
    def launchConfigurationName: Option[NonEmptyString]
    def placementTenancy: Option[NonEmptyString]
    def ramdiskId: Option[NonEmptyString]
    def securityGroups: Option[List[NonEmptyString]]
    def spotPrice: Option[NonEmptyString]
    def userData: Option[NonEmptyString]
    def metadataOptions: Option[
      zio.aws.securityhub.model.AwsAutoScalingLaunchConfigurationMetadataOptions.ReadOnly
    ]
    def getAssociatePublicIpAddress: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("associatePublicIpAddress", associatePublicIpAddress)
    def getBlockDeviceMappings: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails.ReadOnly
    ]] = AwsError.unwrapOptionField("blockDeviceMappings", blockDeviceMappings)
    def getClassicLinkVpcId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("classicLinkVpcId", classicLinkVpcId)
    def getClassicLinkVpcSecurityGroups
        : ZIO[Any, AwsError, List[NonEmptyString]] = AwsError.unwrapOptionField(
      "classicLinkVpcSecurityGroups",
      classicLinkVpcSecurityGroups
    )
    def getCreatedTime: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("createdTime", createdTime)
    def getEbsOptimized: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("ebsOptimized", ebsOptimized)
    def getIamInstanceProfile: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("iamInstanceProfile", iamInstanceProfile)
    def getImageId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("imageId", imageId)
    def getInstanceMonitoring: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsAutoScalingLaunchConfigurationInstanceMonitoringDetails.ReadOnly
    ] = AwsError.unwrapOptionField("instanceMonitoring", instanceMonitoring)
    def getInstanceType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("instanceType", instanceType)
    def getKernelId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("kernelId", kernelId)
    def getKeyName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("keyName", keyName)
    def getLaunchConfigurationName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField(
        "launchConfigurationName",
        launchConfigurationName
      )
    def getPlacementTenancy: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("placementTenancy", placementTenancy)
    def getRamdiskId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("ramdiskId", ramdiskId)
    def getSecurityGroups: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("securityGroups", securityGroups)
    def getSpotPrice: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("spotPrice", spotPrice)
    def getUserData: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("userData", userData)
    def getMetadataOptions: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsAutoScalingLaunchConfigurationMetadataOptions.ReadOnly
    ] = AwsError.unwrapOptionField("metadataOptions", metadataOptions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsAutoScalingLaunchConfigurationDetails
  ) extends zio.aws.securityhub.model.AwsAutoScalingLaunchConfigurationDetails.ReadOnly {
    override val associatePublicIpAddress: Option[Boolean] =
      scala.Option(impl.associatePublicIpAddress()).map(value => value: Boolean)
    override val blockDeviceMappings: Option[List[
      zio.aws.securityhub.model.AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails.ReadOnly
    ]] = scala
      .Option(impl.blockDeviceMappings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails
            .wrap(item)
        }.toList
      )
    override val classicLinkVpcId: Option[NonEmptyString] = scala
      .Option(impl.classicLinkVpcId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val classicLinkVpcSecurityGroups: Option[List[NonEmptyString]] =
      scala
        .Option(impl.classicLinkVpcSecurityGroups())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.primitives.NonEmptyString(item)
          }.toList
        )
    override val createdTime: Option[NonEmptyString] = scala
      .Option(impl.createdTime())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val ebsOptimized: Option[Boolean] =
      scala.Option(impl.ebsOptimized()).map(value => value: Boolean)
    override val iamInstanceProfile: Option[NonEmptyString] = scala
      .Option(impl.iamInstanceProfile())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val imageId: Option[NonEmptyString] = scala
      .Option(impl.imageId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val instanceMonitoring: Option[
      zio.aws.securityhub.model.AwsAutoScalingLaunchConfigurationInstanceMonitoringDetails.ReadOnly
    ] = scala
      .Option(impl.instanceMonitoring())
      .map(value =>
        zio.aws.securityhub.model.AwsAutoScalingLaunchConfigurationInstanceMonitoringDetails
          .wrap(value)
      )
    override val instanceType: Option[NonEmptyString] = scala
      .Option(impl.instanceType())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val kernelId: Option[NonEmptyString] = scala
      .Option(impl.kernelId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val keyName: Option[NonEmptyString] = scala
      .Option(impl.keyName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val launchConfigurationName: Option[NonEmptyString] = scala
      .Option(impl.launchConfigurationName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val placementTenancy: Option[NonEmptyString] = scala
      .Option(impl.placementTenancy())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val ramdiskId: Option[NonEmptyString] = scala
      .Option(impl.ramdiskId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val securityGroups: Option[List[NonEmptyString]] = scala
      .Option(impl.securityGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.primitives.NonEmptyString(item)
        }.toList
      )
    override val spotPrice: Option[NonEmptyString] = scala
      .Option(impl.spotPrice())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val userData: Option[NonEmptyString] = scala
      .Option(impl.userData())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val metadataOptions: Option[
      zio.aws.securityhub.model.AwsAutoScalingLaunchConfigurationMetadataOptions.ReadOnly
    ] = scala
      .Option(impl.metadataOptions())
      .map(value =>
        zio.aws.securityhub.model.AwsAutoScalingLaunchConfigurationMetadataOptions
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsAutoScalingLaunchConfigurationDetails
  ): zio.aws.securityhub.model.AwsAutoScalingLaunchConfigurationDetails.ReadOnly =
    new Wrapper(impl)
}
