package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsApiGatewayAccessLogSettings(
    format: Option[NonEmptyString] = None,
    destinationArn: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsApiGatewayAccessLogSettings = {
    import AwsApiGatewayAccessLogSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsApiGatewayAccessLogSettings
      .builder()
      .optionallyWith(
        format.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.format)
      .optionallyWith(
        destinationArn.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.destinationArn)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsApiGatewayAccessLogSettings.ReadOnly =
    zio.aws.securityhub.model.AwsApiGatewayAccessLogSettings
      .wrap(buildAwsValue())
}
object AwsApiGatewayAccessLogSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsApiGatewayAccessLogSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsApiGatewayAccessLogSettings =
      zio.aws.securityhub.model.AwsApiGatewayAccessLogSettings(
        format.map(value => value),
        destinationArn.map(value => value)
      )
    def format: Option[NonEmptyString]
    def destinationArn: Option[NonEmptyString]
    def getFormat: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("format", format)
    def getDestinationArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("destinationArn", destinationArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsApiGatewayAccessLogSettings
  ) extends zio.aws.securityhub.model.AwsApiGatewayAccessLogSettings.ReadOnly {
    override val format: Option[NonEmptyString] = scala
      .Option(impl.format())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val destinationArn: Option[NonEmptyString] = scala
      .Option(impl.destinationArn())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsApiGatewayAccessLogSettings
  ): zio.aws.securityhub.model.AwsApiGatewayAccessLogSettings.ReadOnly =
    new Wrapper(impl)
}
