package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{NonEmptyString, Integer}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ActionLocalPortDetails(
    port: Option[Integer] = None,
    portName: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.ActionLocalPortDetails = {
    import ActionLocalPortDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.ActionLocalPortDetails
      .builder()
      .optionallyWith(
        port.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.port)
      .optionallyWith(
        portName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.portName)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.ActionLocalPortDetails.ReadOnly =
    zio.aws.securityhub.model.ActionLocalPortDetails.wrap(buildAwsValue())
}
object ActionLocalPortDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.ActionLocalPortDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.ActionLocalPortDetails =
      zio.aws.securityhub.model.ActionLocalPortDetails(
        port.map(value => value),
        portName.map(value => value)
      )
    def port: Option[Integer]
    def portName: Option[NonEmptyString]
    def getPort: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("port", port)
    def getPortName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("portName", portName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.ActionLocalPortDetails
  ) extends zio.aws.securityhub.model.ActionLocalPortDetails.ReadOnly {
    override val port: Option[Integer] = scala
      .Option(impl.port())
      .map(value => zio.aws.securityhub.model.primitives.Integer(value))
    override val portName: Option[NonEmptyString] = scala
      .Option(impl.portName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.ActionLocalPortDetails
  ): zio.aws.securityhub.model.ActionLocalPortDetails.ReadOnly = new Wrapper(
    impl
  )
}
