package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class RuleGroupVariables(
    ipSets: Option[zio.aws.securityhub.model.RuleGroupVariablesIpSetsDetails] =
      None,
    portSets: Option[
      zio.aws.securityhub.model.RuleGroupVariablesPortSetsDetails
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.RuleGroupVariables = {
    import RuleGroupVariables.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.RuleGroupVariables
      .builder()
      .optionallyWith(ipSets.map(value => value.buildAwsValue()))(_.ipSets)
      .optionallyWith(portSets.map(value => value.buildAwsValue()))(_.portSets)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.RuleGroupVariables.ReadOnly =
    zio.aws.securityhub.model.RuleGroupVariables.wrap(buildAwsValue())
}
object RuleGroupVariables {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.RuleGroupVariables
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.RuleGroupVariables =
      zio.aws.securityhub.model.RuleGroupVariables(
        ipSets.map(value => value.asEditable),
        portSets.map(value => value.asEditable)
      )
    def ipSets: Option[
      zio.aws.securityhub.model.RuleGroupVariablesIpSetsDetails.ReadOnly
    ]
    def portSets: Option[
      zio.aws.securityhub.model.RuleGroupVariablesPortSetsDetails.ReadOnly
    ]
    def getIpSets: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.RuleGroupVariablesIpSetsDetails.ReadOnly
    ] = AwsError.unwrapOptionField("ipSets", ipSets)
    def getPortSets: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.RuleGroupVariablesPortSetsDetails.ReadOnly
    ] = AwsError.unwrapOptionField("portSets", portSets)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.RuleGroupVariables
  ) extends zio.aws.securityhub.model.RuleGroupVariables.ReadOnly {
    override val ipSets: Option[
      zio.aws.securityhub.model.RuleGroupVariablesIpSetsDetails.ReadOnly
    ] = scala
      .Option(impl.ipSets())
      .map(value =>
        zio.aws.securityhub.model.RuleGroupVariablesIpSetsDetails.wrap(value)
      )
    override val portSets: Option[
      zio.aws.securityhub.model.RuleGroupVariablesPortSetsDetails.ReadOnly
    ] = scala
      .Option(impl.portSets())
      .map(value =>
        zio.aws.securityhub.model.RuleGroupVariablesPortSetsDetails.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.RuleGroupVariables
  ): zio.aws.securityhub.model.RuleGroupVariables.ReadOnly = new Wrapper(impl)
}
