package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class RuleGroupSourceCustomActionsDetails(
    actionDefinition: Option[
      zio.aws.securityhub.model.StatelessCustomActionDefinition
    ] = None,
    actionName: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.RuleGroupSourceCustomActionsDetails = {
    import RuleGroupSourceCustomActionsDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.RuleGroupSourceCustomActionsDetails
      .builder()
      .optionallyWith(actionDefinition.map(value => value.buildAwsValue()))(
        _.actionDefinition
      )
      .optionallyWith(
        actionName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.actionName)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.RuleGroupSourceCustomActionsDetails.ReadOnly =
    zio.aws.securityhub.model.RuleGroupSourceCustomActionsDetails
      .wrap(buildAwsValue())
}
object RuleGroupSourceCustomActionsDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.RuleGroupSourceCustomActionsDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.RuleGroupSourceCustomActionsDetails =
      zio.aws.securityhub.model.RuleGroupSourceCustomActionsDetails(
        actionDefinition.map(value => value.asEditable),
        actionName.map(value => value)
      )
    def actionDefinition: Option[
      zio.aws.securityhub.model.StatelessCustomActionDefinition.ReadOnly
    ]
    def actionName: Option[NonEmptyString]
    def getActionDefinition: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.StatelessCustomActionDefinition.ReadOnly
    ] = AwsError.unwrapOptionField("actionDefinition", actionDefinition)
    def getActionName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("actionName", actionName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.RuleGroupSourceCustomActionsDetails
  ) extends zio.aws.securityhub.model.RuleGroupSourceCustomActionsDetails.ReadOnly {
    override val actionDefinition: Option[
      zio.aws.securityhub.model.StatelessCustomActionDefinition.ReadOnly
    ] = scala
      .Option(impl.actionDefinition())
      .map(value =>
        zio.aws.securityhub.model.StatelessCustomActionDefinition.wrap(value)
      )
    override val actionName: Option[NonEmptyString] = scala
      .Option(impl.actionName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.RuleGroupSourceCustomActionsDetails
  ): zio.aws.securityhub.model.RuleGroupSourceCustomActionsDetails.ReadOnly =
    new Wrapper(impl)
}
