package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PortProbeDetail(
    localPortDetails: Option[zio.aws.securityhub.model.ActionLocalPortDetails] =
      None,
    localIpDetails: Option[zio.aws.securityhub.model.ActionLocalIpDetails] =
      None,
    remoteIpDetails: Option[zio.aws.securityhub.model.ActionRemoteIpDetails] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.PortProbeDetail = {
    import PortProbeDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.PortProbeDetail
      .builder()
      .optionallyWith(localPortDetails.map(value => value.buildAwsValue()))(
        _.localPortDetails
      )
      .optionallyWith(localIpDetails.map(value => value.buildAwsValue()))(
        _.localIpDetails
      )
      .optionallyWith(remoteIpDetails.map(value => value.buildAwsValue()))(
        _.remoteIpDetails
      )
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.PortProbeDetail.ReadOnly =
    zio.aws.securityhub.model.PortProbeDetail.wrap(buildAwsValue())
}
object PortProbeDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.PortProbeDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.PortProbeDetail =
      zio.aws.securityhub.model.PortProbeDetail(
        localPortDetails.map(value => value.asEditable),
        localIpDetails.map(value => value.asEditable),
        remoteIpDetails.map(value => value.asEditable)
      )
    def localPortDetails
        : Option[zio.aws.securityhub.model.ActionLocalPortDetails.ReadOnly]
    def localIpDetails
        : Option[zio.aws.securityhub.model.ActionLocalIpDetails.ReadOnly]
    def remoteIpDetails
        : Option[zio.aws.securityhub.model.ActionRemoteIpDetails.ReadOnly]
    def getLocalPortDetails: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.ActionLocalPortDetails.ReadOnly
    ] = AwsError.unwrapOptionField("localPortDetails", localPortDetails)
    def getLocalIpDetails: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.ActionLocalIpDetails.ReadOnly
    ] = AwsError.unwrapOptionField("localIpDetails", localIpDetails)
    def getRemoteIpDetails: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.ActionRemoteIpDetails.ReadOnly
    ] = AwsError.unwrapOptionField("remoteIpDetails", remoteIpDetails)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.PortProbeDetail
  ) extends zio.aws.securityhub.model.PortProbeDetail.ReadOnly {
    override val localPortDetails
        : Option[zio.aws.securityhub.model.ActionLocalPortDetails.ReadOnly] =
      scala
        .Option(impl.localPortDetails())
        .map(value =>
          zio.aws.securityhub.model.ActionLocalPortDetails.wrap(value)
        )
    override val localIpDetails
        : Option[zio.aws.securityhub.model.ActionLocalIpDetails.ReadOnly] =
      scala
        .Option(impl.localIpDetails())
        .map(value =>
          zio.aws.securityhub.model.ActionLocalIpDetails.wrap(value)
        )
    override val remoteIpDetails
        : Option[zio.aws.securityhub.model.ActionRemoteIpDetails.ReadOnly] =
      scala
        .Option(impl.remoteIpDetails())
        .map(value =>
          zio.aws.securityhub.model.ActionRemoteIpDetails.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.PortProbeDetail
  ): zio.aws.securityhub.model.PortProbeDetail.ReadOnly = new Wrapper(impl)
}
