package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetInsightsResponse(
    insights: Iterable[zio.aws.securityhub.model.Insight],
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.GetInsightsResponse = {
    import GetInsightsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.GetInsightsResponse
      .builder()
      .insights(insights.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.GetInsightsResponse.ReadOnly =
    zio.aws.securityhub.model.GetInsightsResponse.wrap(buildAwsValue())
}
object GetInsightsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.GetInsightsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.GetInsightsResponse =
      zio.aws.securityhub.model.GetInsightsResponse(
        insights.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def insights: List[zio.aws.securityhub.model.Insight.ReadOnly]
    def nextToken: Option[NextToken]
    def getInsights
        : ZIO[Any, Nothing, List[zio.aws.securityhub.model.Insight.ReadOnly]] =
      ZIO.succeed(insights)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.GetInsightsResponse
  ) extends zio.aws.securityhub.model.GetInsightsResponse.ReadOnly {
    override val insights: List[zio.aws.securityhub.model.Insight.ReadOnly] =
      impl
        .insights()
        .asScala
        .map { item =>
          zio.aws.securityhub.model.Insight.wrap(item)
        }
        .toList
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.securityhub.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.GetInsightsResponse
  ): zio.aws.securityhub.model.GetInsightsResponse.ReadOnly = new Wrapper(impl)
}
